/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.client.renderer;

import com.blocklogic.realfilingreborn.block.entity.FilingCabinetBlockEntity;
import com.blocklogic.realfilingreborn.block.entity.FilingIndexBlockEntity;
import com.blocklogic.realfilingreborn.block.entity.FluidCabinetBlockEntity;
import com.blocklogic.realfilingreborn.component.LedgerData;
import com.blocklogic.realfilingreborn.component.ModDataComponents;
import com.blocklogic.realfilingreborn.item.custom.LedgerItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class LedgerWireframeRenderer {
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        BlockEntity blockEntity;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        ClientLevel level = minecraft.level;
        if (player == null || level == null) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        ItemStack ledgerStack = null;
        if (mainHand.getItem() instanceof LedgerItem) {
            ledgerStack = mainHand;
        } else if (offHand.getItem() instanceof LedgerItem) {
            ledgerStack = offHand;
        }
        if (ledgerStack == null) {
            return;
        }
        LedgerData data = (LedgerData)ledgerStack.getOrDefault((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)LedgerData.DEFAULT);
        PoseStack poseStack = event.getPoseStack();
        Vec3 cameraPos = event.getCamera().getPosition();
        if (data.selectedController() != null) {
            LedgerWireframeRenderer.renderIndexWireframe(poseStack, cameraPos, data.selectedController(), (Level)level);
        }
        if (data.selectedController() != null && (blockEntity = level.getBlockEntity(data.selectedController())) instanceof FilingIndexBlockEntity) {
            FilingIndexBlockEntity indexEntity = (FilingIndexBlockEntity)blockEntity;
            LedgerWireframeRenderer.renderConnectedCabinetsWireframe(poseStack, cameraPos, indexEntity.getLinkedCabinets(), (Level)level);
            LedgerWireframeRenderer.renderRangeWireframe(poseStack, cameraPos, data.selectedController(), indexEntity.getRange());
        }
        if (data.firstMultiPos() != null && data.selectionMode() == LedgerData.SelectionMode.MULTI) {
            LedgerWireframeRenderer.renderMultiSelectionWireframe(poseStack, cameraPos, data.firstMultiPos(), (Level)level, minecraft);
        }
    }

    private static void renderIndexWireframe(PoseStack poseStack, Vec3 cameraPos, BlockPos indexPos, Level level) {
        if (!(level.getBlockEntity(indexPos) instanceof FilingIndexBlockEntity)) {
            return;
        }
        AABB aabb = new AABB(indexPos);
        LedgerWireframeRenderer.renderWireframeBox(poseStack, cameraPos, aabb, 0.0f, 1.0f, 0.0f, 0.8f);
    }

    private static void renderConnectedCabinetsWireframe(PoseStack poseStack, Vec3 cameraPos, Set<BlockPos> linkedCabinets, Level level) {
        for (BlockPos cabinetPos : linkedCabinets) {
            FilingCabinetBlockEntity cabinet;
            boolean isValidCabinet = false;
            BlockEntity blockEntity = level.getBlockEntity(cabinetPos);
            if (blockEntity instanceof FilingCabinetBlockEntity && (cabinet = (FilingCabinetBlockEntity)blockEntity).isLinkedToController()) {
                isValidCabinet = true;
            } else {
                FluidCabinetBlockEntity fluidCabinet;
                blockEntity = level.getBlockEntity(cabinetPos);
                if (blockEntity instanceof FluidCabinetBlockEntity && (fluidCabinet = (FluidCabinetBlockEntity)blockEntity).isLinkedToController()) {
                    isValidCabinet = true;
                }
            }
            if (!isValidCabinet) continue;
            AABB aabb = new AABB(cabinetPos);
            LedgerWireframeRenderer.renderWireframeBox(poseStack, cameraPos, aabb, 1.0f, 1.0f, 1.0f, 0.6f);
        }
    }

    private static void renderRangeWireframe(PoseStack poseStack, Vec3 cameraPos, BlockPos indexPos, int range) {
        double minX = indexPos.getX() - range;
        double maxX = (double)(indexPos.getX() + range) + 1.0;
        double minY = indexPos.getY() - range;
        double maxY = (double)(indexPos.getY() + range) + 1.0;
        double minZ = indexPos.getZ() - range;
        double maxZ = (double)(indexPos.getZ() + range) + 1.0;
        AABB rangeAABB = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        LedgerWireframeRenderer.renderWireframeBox(poseStack, cameraPos, rangeAABB, 1.0f, 1.0f, 0.0f, 0.3f);
    }

    private static void renderMultiSelectionWireframe(PoseStack poseStack, Vec3 cameraPos, BlockPos firstPos, Level level, Minecraft minecraft) {
        HitResult hitResult = minecraft.hitResult;
        if (hitResult != null && hitResult.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos currentPos = blockHitResult.getBlockPos();
            int minX = Math.min(firstPos.getX(), currentPos.getX());
            int maxX = Math.max(firstPos.getX(), currentPos.getX());
            int minY = Math.min(firstPos.getY(), currentPos.getY());
            int maxY = Math.max(firstPos.getY(), currentPos.getY());
            int minZ = Math.min(firstPos.getZ(), currentPos.getZ());
            int maxZ = Math.max(firstPos.getZ(), currentPos.getZ());
            AABB selectionArea = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX + 1.0, (double)maxY + 1.0, (double)maxZ + 1.0);
            LedgerWireframeRenderer.renderWireframeBox(poseStack, cameraPos, selectionArea, 1.0f, 1.0f, 1.0f, 0.6f);
        }
    }

    private static void renderWireframeBox(PoseStack poseStack, Vec3 cameraPos, AABB aabb, float red, float green, float blue, float alpha) {
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.lines());
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (AABB)aabb, (float)red, (float)green, (float)blue, (float)alpha);
        bufferSource.endBatch(RenderType.lines());
        poseStack.popPose();
    }
}

