/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.capability;

import com.blocklogic.realfilingreborn.block.entity.FilingCabinetBlockEntity;
import com.blocklogic.realfilingreborn.block.entity.FilingIndexBlockEntity;
import com.blocklogic.realfilingreborn.config.Config;
import com.blocklogic.realfilingreborn.item.custom.FilingFolderItem;
import com.blocklogic.realfilingreborn.item.custom.NBTFilingFolderItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class FilingIndexItemHandler
implements IItemHandler {
    private final FilingIndexBlockEntity indexEntity;
    private final Level level;
    private volatile List<VirtualSlotInfo> cachedVirtualSlots = null;
    private final AtomicLong lastCacheTime = new AtomicLong(0L);
    private final AtomicLong cacheVersion = new AtomicLong(0L);
    private static final long CACHE_DURATION_MS = 500L;
    private static final int MAX_VIRTUAL_SLOTS_PER_SCAN = 1000;
    private final Map<BlockPos, Boolean> inRangeCache = new ConcurrentHashMap<BlockPos, Boolean>();
    private volatile long lastRangeCacheTime = 0L;
    private static final long RANGE_CACHE_DURATION_MS = 2000L;

    public FilingIndexItemHandler(FilingIndexBlockEntity indexEntity) {
        this.indexEntity = indexEntity;
        this.level = indexEntity.getLevel();
    }

    private void notifyUpdate(BlockPos cabinetPos) {
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(cabinetPos, this.level.getBlockState(cabinetPos), this.level.getBlockState(cabinetPos), 2);
            this.invalidateCache();
        }
    }

    public void invalidateCache() {
        this.cachedVirtualSlots = null;
        this.cacheVersion.incrementAndGet();
        this.lastCacheTime.set(0L);
    }

    private void invalidateRangeCache() {
        this.inRangeCache.clear();
        this.lastRangeCacheTime = 0L;
    }

    private List<VirtualSlotInfo> getAllVirtualSlots() {
        long currentTime = System.currentTimeMillis();
        long currentVersion = this.cacheVersion.get();
        List<VirtualSlotInfo> cached = this.cachedVirtualSlots;
        if (cached != null && currentTime - this.lastCacheTime.get() < 500L) {
            return cached;
        }
        ArrayList<VirtualSlotInfo> virtualSlots = new ArrayList<VirtualSlotInfo>();
        int slotCount = 0;
        ArrayList<BlockPos> cabinets = new ArrayList<BlockPos>(this.indexEntity.getLinkedCabinets());
        for (BlockPos cabinetPos : cabinets) {
            FilingCabinetBlockEntity cabinet;
            BlockEntity blockEntity;
            if (slotCount >= 1000) break;
            if (!this.isInRangeCached(cabinetPos) || !((blockEntity = this.level.getBlockEntity(cabinetPos)) instanceof FilingCabinetBlockEntity) || !(cabinet = (FilingCabinetBlockEntity)blockEntity).isLinkedToController()) continue;
            for (int slot = 0; slot < 5 && slotCount < 1000; ++slot) {
                Record contents;
                ItemStack folderStack = cabinet.inventory.getStackInSlot(slot);
                if (folderStack.getItem() instanceof FilingFolderItem && !(folderStack.getItem() instanceof NBTFilingFolderItem)) {
                    contents = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
                    if (contents == null || !((FilingFolderItem.FolderContents)contents).storedItemId().isPresent() || ((FilingFolderItem.FolderContents)contents).count() <= 0) continue;
                    ResourceLocation itemId = ((FilingFolderItem.FolderContents)contents).storedItemId().get();
                    Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
                    virtualSlots.add(new VirtualSlotInfo(cabinetPos, slot, VirtualSlotType.FILING_FOLDER, new ItemStack((ItemLike)item, ((FilingFolderItem.FolderContents)contents).count())));
                    ++slotCount;
                    continue;
                }
                if (!(folderStack.getItem() instanceof NBTFilingFolderItem) || (contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value())) == null || !((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId().isPresent() || ((NBTFilingFolderItem.NBTFolderContents)contents).storedItems().isEmpty()) continue;
                int itemsToProcess = Math.min(((NBTFilingFolderItem.NBTFolderContents)contents).storedItems().size(), 100);
                for (int i = 0; i < itemsToProcess && slotCount < 1000; ++slotCount, ++i) {
                    NBTFilingFolderItem.SerializedItemStack serializedItem = ((NBTFilingFolderItem.NBTFolderContents)contents).storedItems().get(i);
                    virtualSlots.add(new VirtualSlotInfo(cabinetPos, slot, VirtualSlotType.NBT_FOLDER, serializedItem.stack().copy(), i));
                }
            }
        }
        if (currentVersion == this.cacheVersion.get()) {
            this.cachedVirtualSlots = virtualSlots;
            this.lastCacheTime.set(currentTime);
        }
        return virtualSlots;
    }

    private boolean isInRangeCached(BlockPos cabinetPos) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRangeCacheTime > 2000L) {
            this.invalidateRangeCache();
            this.lastRangeCacheTime = currentTime;
        }
        return this.inRangeCache.computeIfAbsent(cabinetPos, pos -> this.indexEntity.isInRange((BlockPos)pos));
    }

    public int getSlots() {
        return Math.max(this.indexEntity.getLinkedCabinetCount() * 5, 1);
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        FilingCabinetBlockEntity cabinet;
        ArrayList<BlockPos> cabinets = new ArrayList<BlockPos>(this.indexEntity.getLinkedCabinets());
        int cabinetIndex = slot / 5;
        int cabinetSlot = slot % 5;
        if (cabinetIndex >= cabinets.size()) {
            return ItemStack.EMPTY;
        }
        BlockPos cabinetPos = (BlockPos)cabinets.get(cabinetIndex);
        if (!this.isInRangeCached(cabinetPos)) {
            return ItemStack.EMPTY;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(cabinetPos);
        if (blockEntity instanceof FilingCabinetBlockEntity && (cabinet = (FilingCabinetBlockEntity)blockEntity).isLinkedToController()) {
            NBTFilingFolderItem.NBTFolderContents contents;
            ItemStack folderStack = cabinet.inventory.getStackInSlot(cabinetSlot);
            if (folderStack.getItem() instanceof FilingFolderItem && !(folderStack.getItem() instanceof NBTFilingFolderItem)) {
                FilingFolderItem.FolderContents contents2 = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
                if (contents2 != null && contents2.storedItemId().isPresent() && contents2.count() > 0) {
                    Item item = (Item)BuiltInRegistries.ITEM.get(contents2.storedItemId().get());
                    return new ItemStack((ItemLike)item, Math.min(contents2.count(), item.getDefaultMaxStackSize()));
                }
            } else if (folderStack.getItem() instanceof NBTFilingFolderItem && (contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value())) != null && !contents.storedItems().isEmpty()) {
                return contents.storedItems().get(0).stack().copy();
            }
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack result;
        FilingCabinetBlockEntity cabinet;
        BlockEntity blockEntity;
        BlockPos cabinetPos;
        if (stack.isEmpty()) {
            return stack;
        }
        ArrayList<BlockPos> cabinets = new ArrayList<BlockPos>(this.indexEntity.getLinkedCabinets());
        int cabinetIndex = slot / 5;
        int cabinetSlot = slot % 5;
        if (cabinetIndex < cabinets.size() && this.isInRangeCached(cabinetPos = (BlockPos)cabinets.get(cabinetIndex)) && (blockEntity = this.level.getBlockEntity(cabinetPos)) instanceof FilingCabinetBlockEntity && (cabinet = (FilingCabinetBlockEntity)blockEntity).isLinkedToController() && (result = this.insertItemIntoCabinet(cabinet, cabinetSlot, stack, simulate, cabinetPos)).getCount() < stack.getCount()) {
            return result;
        }
        boolean hasNBT = NBTFilingFolderItem.hasSignificantNBT(stack);
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        for (BlockPos cabinetPos2 : cabinets) {
            FilingCabinetBlockEntity cabinet2;
            BlockEntity blockEntity2;
            if (!this.isInRangeCached(cabinetPos2) || !((blockEntity2 = this.level.getBlockEntity(cabinetPos2)) instanceof FilingCabinetBlockEntity) || !(cabinet2 = (FilingCabinetBlockEntity)blockEntity2).isLinkedToController()) continue;
            for (int i = 0; i < 5; ++i) {
                ItemStack result2 = this.tryInsertIntoFolder(cabinet2, i, stack, itemId, hasNBT, simulate, cabinetPos2);
                if (result2.getCount() >= stack.getCount()) continue;
                return result2;
            }
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        FilingCabinetBlockEntity cabinet;
        BlockEntity blockEntity;
        BlockPos cabinetPos;
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        ArrayList<BlockPos> cabinets = new ArrayList<BlockPos>(this.indexEntity.getLinkedCabinets());
        int cabinetIndex = slot / 5;
        int cabinetSlot = slot % 5;
        if (cabinetIndex < cabinets.size() && this.isInRangeCached(cabinetPos = (BlockPos)cabinets.get(cabinetIndex)) && (blockEntity = this.level.getBlockEntity(cabinetPos)) instanceof FilingCabinetBlockEntity && (cabinet = (FilingCabinetBlockEntity)blockEntity).isLinkedToController()) {
            return this.extractFromCabinet(cabinet, cabinetSlot, amount, simulate, cabinetPos);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack insertItemIntoCabinet(FilingCabinetBlockEntity cabinet, int cabinetSlot, ItemStack stack, boolean simulate, BlockPos cabinetPos) {
        try {
            ItemStack folderStack = cabinet.inventory.getStackInSlot(cabinetSlot);
            if (folderStack.isEmpty()) {
                return stack;
            }
            boolean hasNBT = NBTFilingFolderItem.hasSignificantNBT(stack);
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            return this.tryInsertIntoFolder(cabinet, cabinetSlot, stack, itemId, hasNBT, simulate, cabinetPos);
        }
        catch (Exception e) {
            return stack;
        }
    }

    private ItemStack tryInsertIntoFolder(FilingCabinetBlockEntity cabinet, int cabinetSlot, ItemStack stack, ResourceLocation itemId, boolean hasNBT, boolean simulate, BlockPos cabinetPos) {
        try {
            ItemStack folderStack = cabinet.inventory.getStackInSlot(cabinetSlot);
            if (folderStack.isEmpty()) {
                return stack;
            }
            if (folderStack.getItem() instanceof FilingFolderItem && !(folderStack.getItem() instanceof NBTFilingFolderItem)) {
                if (hasNBT) {
                    return stack;
                }
                FilingFolderItem.FolderContents contents = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
                if (contents == null) {
                    return stack;
                }
                if (contents.storedItemId().isPresent() && contents.storedItemId().get().equals((Object)itemId)) {
                    int maxAdd;
                    if (contents.count() > Integer.MAX_VALUE - stack.getCount()) {
                        return stack;
                    }
                    long newTotal = (long)contents.count() + (long)stack.getCount();
                    int n = maxAdd = newTotal > Integer.MAX_VALUE ? Integer.MAX_VALUE - contents.count() : stack.getCount();
                    if (maxAdd > 0 && !simulate) {
                        FilingFolderItem.FolderContents newContents = new FilingFolderItem.FolderContents(contents.storedItemId(), contents.count() + maxAdd);
                        folderStack.set((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value(), (Object)newContents);
                        cabinet.setChanged();
                        this.notifyUpdate(cabinetPos);
                    }
                    ItemStack remaining = stack.copy();
                    remaining.shrink(maxAdd);
                    return remaining;
                }
            } else if (folderStack.getItem() instanceof NBTFilingFolderItem) {
                if (!hasNBT) {
                    return stack;
                }
                NBTFilingFolderItem.NBTFolderContents contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
                if (contents == null) {
                    return stack;
                }
                if (contents.storedItemId().isPresent() && contents.storedItemId().get().equals((Object)itemId)) {
                    int space = Config.getMaxNBTFolderStorage() - contents.storedItems().size();
                    int canAdd = Math.min(1, space);
                    if (canAdd > 0 && !simulate) {
                        ArrayList<NBTFilingFolderItem.SerializedItemStack> newItems = new ArrayList<NBTFilingFolderItem.SerializedItemStack>(contents.storedItems());
                        ItemStack single = stack.copy();
                        single.setCount(1);
                        newItems.add(new NBTFilingFolderItem.SerializedItemStack(single));
                        NBTFilingFolderItem.NBTFolderContents newContents = new NBTFilingFolderItem.NBTFolderContents(contents.storedItemId(), newItems);
                        folderStack.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)newContents);
                        cabinet.setChanged();
                        this.notifyUpdate(cabinetPos);
                    }
                    ItemStack remaining = stack.copy();
                    remaining.shrink(canAdd);
                    return remaining;
                }
            }
            return stack;
        }
        catch (Exception e) {
            return stack;
        }
    }

    private ItemStack extractFromCabinet(FilingCabinetBlockEntity cabinet, int cabinetSlot, int amount, boolean simulate, BlockPos cabinetPos) {
        try {
            NBTFilingFolderItem.NBTFolderContents contents;
            ItemStack folderStack = cabinet.inventory.getStackInSlot(cabinetSlot);
            if (folderStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (folderStack.getItem() instanceof FilingFolderItem && !(folderStack.getItem() instanceof NBTFilingFolderItem)) {
                FilingFolderItem.FolderContents contents2 = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
                if (contents2 != null && contents2.storedItemId().isPresent() && contents2.count() > 0) {
                    Item item = (Item)BuiltInRegistries.ITEM.get(contents2.storedItemId().get());
                    int extractAmount = Math.min(amount, Math.min(contents2.count(), item.getDefaultMaxStackSize()));
                    if (extractAmount > 0 && !simulate) {
                        FilingFolderItem.FolderContents newContents = new FilingFolderItem.FolderContents(contents2.storedItemId(), contents2.count() - extractAmount);
                        folderStack.set((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value(), (Object)newContents);
                        cabinet.setChanged();
                        this.notifyUpdate(cabinetPos);
                    }
                    return new ItemStack((ItemLike)item, extractAmount);
                }
            } else if (folderStack.getItem() instanceof NBTFilingFolderItem && (contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value())) != null && !contents.storedItems().isEmpty()) {
                int extractAmount = Math.min(amount, 1);
                if (extractAmount > 0 && !simulate) {
                    ArrayList<NBTFilingFolderItem.SerializedItemStack> newItems = new ArrayList<NBTFilingFolderItem.SerializedItemStack>(contents.storedItems());
                    newItems.remove(newItems.size() - 1);
                    NBTFilingFolderItem.NBTFolderContents newContents = new NBTFilingFolderItem.NBTFolderContents(contents.storedItemId(), newItems);
                    folderStack.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)newContents);
                    cabinet.setChanged();
                    this.notifyUpdate(cabinetPos);
                }
                ItemStack result = contents.storedItems().get(contents.storedItems().size() - 1).stack().copy();
                result.setCount(extractAmount);
                return result;
            }
            return ItemStack.EMPTY;
        }
        catch (Exception e) {
            return ItemStack.EMPTY;
        }
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    private static class VirtualSlotInfo {
        final BlockPos cabinetPos;
        final int slotIndex;
        final VirtualSlotType type;
        final ItemStack virtualStack;
        final int nbtIndex;

        public VirtualSlotInfo(BlockPos cabinetPos, int slotIndex, VirtualSlotType type, ItemStack virtualStack) {
            this(cabinetPos, slotIndex, type, virtualStack, -1);
        }

        public VirtualSlotInfo(BlockPos cabinetPos, int slotIndex, VirtualSlotType type, ItemStack virtualStack, int nbtIndex) {
            this.cabinetPos = cabinetPos;
            this.slotIndex = slotIndex;
            this.type = type;
            this.virtualStack = virtualStack;
            this.nbtIndex = nbtIndex;
        }
    }

    private static enum VirtualSlotType {
        FILING_FOLDER,
        NBT_FOLDER;

    }
}

