/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.capability;

import com.blocklogic.realfilingreborn.block.entity.FilingIndexBlockEntity;
import com.blocklogic.realfilingreborn.block.entity.FluidCabinetBlockEntity;
import com.blocklogic.realfilingreborn.item.custom.FluidCanisterItem;
import com.blocklogic.realfilingreborn.util.FluidHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FilingIndexFluidHandler
implements IFluidHandler {
    private final FilingIndexBlockEntity indexEntity;
    private final Level level;
    private volatile List<FluidTankInfo> cachedFluidTanks = null;
    private final AtomicLong lastCacheTime = new AtomicLong(0L);
    private final AtomicLong cacheVersion = new AtomicLong(0L);
    private static final long CACHE_DURATION_MS = 500L;
    private static final int MAX_FLUID_TANKS_PER_SCAN = 500;
    private final Map<BlockPos, Boolean> inRangeCache = new ConcurrentHashMap<BlockPos, Boolean>();
    private volatile long lastRangeCacheTime = 0L;
    private static final long RANGE_CACHE_DURATION_MS = 2000L;

    public FilingIndexFluidHandler(FilingIndexBlockEntity indexEntity) {
        this.indexEntity = indexEntity;
        this.level = indexEntity.getLevel();
    }

    private void notifyUpdate(BlockPos cabinetPos) {
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(cabinetPos, this.level.getBlockState(cabinetPos), this.level.getBlockState(cabinetPos), 2);
            this.invalidateCache();
        }
    }

    public void invalidateCache() {
        this.cachedFluidTanks = null;
        this.cacheVersion.incrementAndGet();
        this.lastCacheTime.set(0L);
    }

    private void invalidateRangeCache() {
        this.inRangeCache.clear();
        this.lastRangeCacheTime = 0L;
    }

    private List<FluidTankInfo> getAllFluidTanks() {
        long currentTime = System.currentTimeMillis();
        long currentVersion = this.cacheVersion.get();
        List<FluidTankInfo> cached = this.cachedFluidTanks;
        if (cached != null && currentTime - this.lastCacheTime.get() < 500L) {
            return cached;
        }
        ArrayList<FluidTankInfo> tanks = new ArrayList<FluidTankInfo>();
        int tankCount = 0;
        ArrayList<BlockPos> cabinets = new ArrayList<BlockPos>(this.indexEntity.getLinkedCabinets());
        for (BlockPos cabinetPos : cabinets) {
            if (tankCount >= 500) break;
            if (!this.isInRangeCached(cabinetPos)) continue;
            try {
                FluidCabinetBlockEntity fluidCabinet;
                BlockEntity blockEntity = this.level.getBlockEntity(cabinetPos);
                if (!(blockEntity instanceof FluidCabinetBlockEntity) || !(fluidCabinet = (FluidCabinetBlockEntity)blockEntity).isLinkedToController()) continue;
                for (int slot = 0; slot < 4 && tankCount < 500; ++slot) {
                    ResourceLocation fluidId;
                    Fluid fluid;
                    FluidCanisterItem.CanisterContents contents;
                    ItemStack canisterStack = fluidCabinet.inventory.getStackInSlot(slot);
                    if (!(canisterStack.getItem() instanceof FluidCanisterItem) || (contents = (FluidCanisterItem.CanisterContents)canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value())) == null || !contents.storedFluidId().isPresent() || contents.amount() <= 0 || (fluid = FluidHelper.getFluidFromId(fluidId = contents.storedFluidId().get())) == null) continue;
                    tanks.add(new FluidTankInfo(cabinetPos, slot, new FluidStack(fluid, contents.amount())));
                    ++tankCount;
                }
            }
            catch (Exception e) {
            }
        }
        if (currentVersion == this.cacheVersion.get()) {
            this.cachedFluidTanks = tanks;
            this.lastCacheTime.set(currentTime);
        }
        return tanks;
    }

    private boolean isInRangeCached(BlockPos cabinetPos) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRangeCacheTime > 2000L) {
            this.invalidateRangeCache();
            this.lastRangeCacheTime = currentTime;
        }
        return this.inRangeCache.computeIfAbsent(cabinetPos, pos -> {
            try {
                return this.indexEntity.isInRange((BlockPos)pos);
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    public int getTanks() {
        try {
            return this.getAllFluidTanks().size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        try {
            List<FluidTankInfo> tanks = this.getAllFluidTanks();
            if (tank < 0 || tank >= tanks.size()) {
                return FluidStack.EMPTY;
            }
            return tanks.get((int)tank).fluidStack.copy();
        }
        catch (Exception e) {
            return FluidStack.EMPTY;
        }
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        try {
            List<FluidTankInfo> tanks = this.getAllFluidTanks();
            if (tank < 0 || tank >= tanks.size() || stack.isEmpty()) {
                return false;
            }
            FluidTankInfo tankInfo = tanks.get(tank);
            return FluidHelper.areFluidsCompatible(FluidHelper.getFluidId(stack.getFluid()), FluidHelper.getFluidId(tankInfo.fluidStack.getFluid()));
        }
        catch (Exception e) {
            return false;
        }
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !FluidHelper.isValidFluid(resource.getFluid())) {
            return 0;
        }
        try {
            FluidCabinetBlockEntity fluidCabinet;
            ResourceLocation resourceFluidId = FluidHelper.getStillFluid(FluidHelper.getFluidId(resource.getFluid()));
            List<FluidTankInfo> tanks = this.getAllFluidTanks();
            for (FluidTankInfo tankInfo : tanks) {
                int maxToAdd;
                FluidCanisterItem.CanisterContents contents;
                BlockEntity blockEntity;
                ResourceLocation tankFluidId = FluidHelper.getStillFluid(FluidHelper.getFluidId(tankInfo.fluidStack.getFluid()));
                if (!FluidHelper.areFluidsCompatible(resourceFluidId, tankFluidId) || !((blockEntity = this.level.getBlockEntity(tankInfo.cabinetPos)) instanceof FluidCabinetBlockEntity)) continue;
                fluidCabinet = (FluidCabinetBlockEntity)blockEntity;
                ItemStack canisterStack = fluidCabinet.inventory.getStackInSlot(tankInfo.slotIndex);
                if (!(canisterStack.getItem() instanceof FluidCanisterItem) || (contents = (FluidCanisterItem.CanisterContents)canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value())) == null) continue;
                if (contents.amount() > Integer.MAX_VALUE - resource.getAmount()) {
                    return 0;
                }
                long newAmount = (long)contents.amount() + (long)resource.getAmount();
                int n = maxToAdd = newAmount > Integer.MAX_VALUE ? Integer.MAX_VALUE - contents.amount() : resource.getAmount();
                if (maxToAdd > 0 && action.execute()) {
                    FluidCanisterItem.CanisterContents newContents = new FluidCanisterItem.CanisterContents(Optional.of(resourceFluidId), contents.amount() + maxToAdd);
                    canisterStack.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)newContents);
                    fluidCabinet.setChanged();
                    this.notifyUpdate(tankInfo.cabinetPos);
                }
                return maxToAdd;
            }
            ArrayList<BlockPos> cabinets = new ArrayList<BlockPos>(this.indexEntity.getLinkedCabinets());
            for (BlockPos cabinetPos : cabinets) {
                BlockEntity canisterStack;
                if (!this.isInRangeCached(cabinetPos) || !((canisterStack = this.level.getBlockEntity(cabinetPos)) instanceof FluidCabinetBlockEntity) || !(fluidCabinet = (FluidCabinetBlockEntity)canisterStack).isLinkedToController()) continue;
                for (int slot = 0; slot < 4; ++slot) {
                    FluidCanisterItem.CanisterContents contents;
                    ItemStack canisterStack2 = fluidCabinet.inventory.getStackInSlot(slot);
                    if (!(canisterStack2.getItem() instanceof FluidCanisterItem) || (contents = (FluidCanisterItem.CanisterContents)canisterStack2.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value())) == null || !contents.storedFluidId().isEmpty()) continue;
                    int toAdd = Math.min(resource.getAmount(), Integer.MAX_VALUE);
                    if (toAdd > 0 && action.execute()) {
                        FluidCanisterItem.CanisterContents newContents = new FluidCanisterItem.CanisterContents(Optional.of(resourceFluidId), toAdd);
                        canisterStack2.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)newContents);
                        fluidCabinet.setChanged();
                        this.notifyUpdate(cabinetPos);
                    }
                    return toAdd;
                }
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !FluidHelper.isValidFluid(resource.getFluid())) {
            return FluidStack.EMPTY;
        }
        try {
            ResourceLocation resourceFluidId = FluidHelper.getStillFluid(FluidHelper.getFluidId(resource.getFluid()));
            List<FluidTankInfo> tanks = this.getAllFluidTanks();
            for (FluidTankInfo tankInfo : tanks) {
                FluidCanisterItem.CanisterContents contents;
                BlockEntity blockEntity;
                ResourceLocation tankFluidId = FluidHelper.getStillFluid(FluidHelper.getFluidId(tankInfo.fluidStack.getFluid()));
                if (!FluidHelper.areFluidsCompatible(resourceFluidId, tankFluidId) || !((blockEntity = this.level.getBlockEntity(tankInfo.cabinetPos)) instanceof FluidCabinetBlockEntity)) continue;
                FluidCabinetBlockEntity fluidCabinet = (FluidCabinetBlockEntity)blockEntity;
                ItemStack canisterStack = fluidCabinet.inventory.getStackInSlot(tankInfo.slotIndex);
                if (!(canisterStack.getItem() instanceof FluidCanisterItem) || (contents = (FluidCanisterItem.CanisterContents)canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value())) == null || contents.amount() <= 0) continue;
                int toDrain = Math.min(resource.getAmount(), contents.amount());
                if (toDrain > 0 && action.execute()) {
                    FluidCanisterItem.CanisterContents newContents = new FluidCanisterItem.CanisterContents(contents.storedFluidId(), contents.amount() - toDrain);
                    canisterStack.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)newContents);
                    fluidCabinet.setChanged();
                    this.notifyUpdate(tankInfo.cabinetPos);
                }
                return new FluidStack(resource.getFluid(), toDrain);
            }
            return FluidStack.EMPTY;
        }
        catch (Exception e) {
            return FluidStack.EMPTY;
        }
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        try {
            List<FluidTankInfo> tanks = this.getAllFluidTanks();
            for (FluidTankInfo tankInfo : tanks) {
                FluidCanisterItem.CanisterContents contents;
                BlockEntity blockEntity;
                if (tankInfo.fluidStack.getAmount() <= 0 || !((blockEntity = this.level.getBlockEntity(tankInfo.cabinetPos)) instanceof FluidCabinetBlockEntity)) continue;
                FluidCabinetBlockEntity fluidCabinet = (FluidCabinetBlockEntity)blockEntity;
                ItemStack canisterStack = fluidCabinet.inventory.getStackInSlot(tankInfo.slotIndex);
                if (!(canisterStack.getItem() instanceof FluidCanisterItem) || (contents = (FluidCanisterItem.CanisterContents)canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value())) == null || contents.amount() <= 0) continue;
                int toDrain = Math.min(maxDrain, contents.amount());
                if (toDrain > 0 && action.execute()) {
                    FluidCanisterItem.CanisterContents newContents = new FluidCanisterItem.CanisterContents(contents.storedFluidId(), contents.amount() - toDrain);
                    canisterStack.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)newContents);
                    fluidCabinet.setChanged();
                    this.notifyUpdate(tankInfo.cabinetPos);
                }
                return new FluidStack(tankInfo.fluidStack.getFluid(), toDrain);
            }
            return FluidStack.EMPTY;
        }
        catch (Exception e) {
            return FluidStack.EMPTY;
        }
    }

    private static class FluidTankInfo {
        final BlockPos cabinetPos;
        final int slotIndex;
        final FluidStack fluidStack;

        public FluidTankInfo(BlockPos cabinetPos, int slotIndex, FluidStack fluidStack) {
            this.cabinetPos = cabinetPos;
            this.slotIndex = slotIndex;
            this.fluidStack = fluidStack;
        }
    }
}

