/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.block.entity.renderer;

import com.blocklogic.realfilingreborn.block.custom.FluidCabinetBlock;
import com.blocklogic.realfilingreborn.block.entity.FluidCabinetBlockEntity;
import com.blocklogic.realfilingreborn.item.custom.FluidCanisterItem;
import com.blocklogic.realfilingreborn.util.FormattingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class FluidCabinetBlockEntityRenderer
implements BlockEntityRenderer<FluidCabinetBlockEntity> {
    private static final Map<Fluid, IClientFluidTypeExtensions> FLUID_EXTENSIONS_CACHE = new ConcurrentHashMap<Fluid, IClientFluidTypeExtensions>();
    private static final Map<ResourceLocation, TextureAtlasSprite> SPRITE_CACHE = new ConcurrentHashMap<ResourceLocation, TextureAtlasSprite>();
    private static final Minecraft MC = Minecraft.getInstance();
    private static final Font FONT = FluidCabinetBlockEntityRenderer.MC.font;
    private static final float[][] POSITIONS = new float[][]{{-0.188f, 0.188f}, {0.188f, 0.188f}, {-0.188f, -0.188f}, {0.188f, -0.188f}};

    public FluidCabinetBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FluidCabinetBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)FluidCabinetBlock.FACING);
        int itemLight = 0xF000F0;
        poseStack.pushPose();
        this.setupFaceTransform(poseStack, facing);
        this.renderFluidGrid(blockEntity, poseStack, bufferSource, itemLight);
        poseStack.popPose();
    }

    private void setupFaceTransform(PoseStack poseStack, Direction facing) {
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        switch (facing) {
            case NORTH: {
                poseStack.translate(0.0, 0.0, 0.475);
                break;
            }
            case EAST: {
                poseStack.translate(-0.475, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.translate(0.0, 0.0, -0.475);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.translate(0.475, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
        }
        poseStack.translate(0.0, 0.0, -0.03125);
    }

    private void renderFluidGrid(FluidCabinetBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int itemLight) {
        float quadWidth = 0.25f;
        float quadHeight = 0.25f;
        for (int slot = 0; slot < Math.min(4, blockEntity.inventory.getSlots()); ++slot) {
            ResourceLocation fluidId;
            Fluid fluid;
            FluidCanisterItem.CanisterContents contents;
            ItemStack canisterStack = blockEntity.inventory.getStackInSlot(slot);
            if (canisterStack.isEmpty() || !(canisterStack.getItem() instanceof FluidCanisterItem) || (contents = (FluidCanisterItem.CanisterContents)canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value())) == null || !contents.storedFluidId().isPresent() || contents.amount() <= 0 || (fluid = this.getFluidFromId(fluidId = contents.storedFluidId().get())) == null || fluid == Fluids.EMPTY) continue;
            float offsetX = POSITIONS[slot][0];
            float offsetY = POSITIONS[slot][1];
            this.renderFluidQuad(fluid, contents.amount(), offsetX, offsetY, quadWidth, quadHeight, poseStack, bufferSource, itemLight);
            String formattedAmount = FormattingCache.getFormattedFluidAmount(contents.amount());
            this.renderFluidText(formattedAmount, offsetX, offsetY - quadHeight / 2.0f - 0.025f, poseStack, bufferSource, itemLight);
        }
    }

    private void renderFluidQuad(Fluid fluid, int amount, float offsetX, float offsetY, float width, float height, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        try {
            IClientFluidTypeExtensions fluidExtensions = FLUID_EXTENSIONS_CACHE.computeIfAbsent(fluid, IClientFluidTypeExtensions::of);
            ResourceLocation stillTexture = fluidExtensions.getStillTexture();
            if (stillTexture != null) {
                TextureAtlasSprite sprite = SPRITE_CACHE.computeIfAbsent(stillTexture, texture -> (TextureAtlasSprite)MC.getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(texture));
                VertexConsumer consumer = bufferSource.getBuffer(RenderType.translucent());
                Matrix4f matrix = poseStack.last().pose();
                FluidStack fluidStack = new FluidStack(fluid, 1000);
                int color = fluidExtensions.getTintColor(fluidStack);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
                if (alpha == 0.0f) {
                    alpha = 1.0f;
                }
                float maxVisualAmount = 1.0E8f;
                float fillPercentage = Math.min((float)amount / maxVisualAmount, 1.0f);
                float halfWidth = width / 2.0f;
                float halfHeight = height / 2.0f;
                float quadLeft = offsetX - halfWidth;
                float quadRight = offsetX + halfWidth;
                float quadBottom = offsetY - halfHeight;
                float quadTop = offsetY + halfHeight;
                float fillHeight = height * fillPercentage;
                float fluidTop = quadBottom + fillHeight;
                float minU = sprite.getU0();
                float maxU = sprite.getU1();
                float minV = sprite.getV0();
                float maxV = sprite.getV1();
                if (fillPercentage > 0.0f) {
                    float fillVRange = (maxV - minV) * fillPercentage;
                    float adjustedMinV = maxV - fillVRange;
                    consumer.addVertex(matrix, quadLeft, quadBottom, 0.001f).setColor(red, green, blue, alpha).setUv(minU, maxV).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
                    consumer.addVertex(matrix, quadRight, quadBottom, 0.001f).setColor(red, green, blue, alpha).setUv(maxU, maxV).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
                    consumer.addVertex(matrix, quadRight, fluidTop, 0.001f).setColor(red, green, blue, alpha).setUv(maxU, adjustedMinV).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
                    consumer.addVertex(matrix, quadLeft, fluidTop, 0.001f).setColor(red, green, blue, alpha).setUv(minU, adjustedMinV).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
                }
            }
        }
        catch (Exception e) {
            this.renderSolidQuad(0.2f, 0.5f, 1.0f, 0.8f, amount, offsetX, offsetY, width, height, poseStack, bufferSource, packedLight);
        }
    }

    private void renderSolidQuad(float red, float green, float blue, float alpha, int amount, float offsetX, float offsetY, float width, float height, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.translucent());
        Matrix4f matrix = poseStack.last().pose();
        float maxVisualAmount = 1.0E8f;
        float fillPercentage = Math.min((float)amount / maxVisualAmount, 1.0f);
        if (fillPercentage > 0.0f) {
            float halfWidth = width / 2.0f;
            float halfHeight = height / 2.0f;
            float quadLeft = offsetX - halfWidth;
            float quadRight = offsetX + halfWidth;
            float quadBottom = offsetY - halfHeight;
            float fillHeight = height * fillPercentage;
            float fluidTop = quadBottom + fillHeight;
            consumer.addVertex(matrix, quadLeft, quadBottom, 0.001f).setColor(red, green, blue, alpha).setUv(0.0f, 1.0f).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
            consumer.addVertex(matrix, quadRight, quadBottom, 0.001f).setColor(red, green, blue, alpha).setUv(1.0f, 1.0f).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
            consumer.addVertex(matrix, quadRight, fluidTop, 0.001f).setColor(red, green, blue, alpha).setUv(1.0f, 0.0f).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
            consumer.addVertex(matrix, quadLeft, fluidTop, 0.001f).setColor(red, green, blue, alpha).setUv(0.0f, 0.0f).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
        }
    }

    private void renderFluidText(String text, float offsetX, float offsetY, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (text.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(offsetX, offsetY, 0.002f);
        poseStack.scale(0.004f, 0.004f, 0.004f);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        int textWidth = FONT.width(text);
        float xOffset = (float)(-textWidth) / 2.0f;
        FONT.drawInBatch(text, xOffset, 0.0f, 0xFFFFFF, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.popPose();
    }

    private Fluid getFluidFromId(ResourceLocation fluidId) {
        try {
            return (Fluid)BuiltInRegistries.FLUID.get(fluidId);
        }
        catch (Exception e) {
            return Fluids.EMPTY;
        }
    }
}

