/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.block.entity;

import com.blocklogic.realfilingreborn.block.custom.FluidCabinetBlock;
import com.blocklogic.realfilingreborn.block.entity.ModBlockEntities;
import com.blocklogic.realfilingreborn.config.Config;
import com.blocklogic.realfilingreborn.item.custom.FluidCanisterItem;
import com.blocklogic.realfilingreborn.screen.custom.FluidCabinetMenu;
import com.blocklogic.realfilingreborn.util.FluidHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidCabinetBlockEntity
extends BlockEntity
implements MenuProvider {
    @Nullable
    private BlockPos controllerPos = null;
    public final ItemStackHandler inventory = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            FluidCabinetBlockEntity.this.setChanged();
            if (FluidCabinetBlockEntity.this.level != null && !FluidCabinetBlockEntity.this.level.isClientSide()) {
                FluidCabinetBlockEntity.this.level.sendBlockUpdated(FluidCabinetBlockEntity.this.getBlockPos(), FluidCabinetBlockEntity.this.getBlockState(), FluidCabinetBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private final Map<Direction, IItemHandler> handlers = new HashMap<Direction, IItemHandler>();
    private final Map<Direction, IFluidHandler> fluidHandlers = new HashMap<Direction, IFluidHandler>();

    public FluidCabinetBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.FLUID_CABINET_BE.get(), pos, blockState);
    }

    @Nullable
    public IItemHandler getCapabilityHandler(@Nullable Direction side) {
        if (side != null && this.getBlockState().getValue((Property)FluidCabinetBlock.FACING) == side) {
            return null;
        }
        return this.handlers.computeIfAbsent(side != null ? side : Direction.UP, s -> new FluidCabinetItemHandler(this, (Direction)s));
    }

    @Nullable
    public IFluidHandler getFluidCapabilityHandler(@Nullable Direction side) {
        if (side != null && this.getBlockState().getValue((Property)FluidCabinetBlock.FACING) == side) {
            return null;
        }
        return this.fluidHandlers.computeIfAbsent(side != null ? side : Direction.UP, s -> new FluidCabinetFluidHandler(this, (Direction)s));
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        if (this.controllerPos != null) {
            tag.putLong("controllerPos", this.controllerPos.asLong());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.controllerPos = tag.contains("controllerPos") ? BlockPos.of((long)tag.getLong("controllerPos")) : null;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"blockentity.realfilingreborn.fluid_cabinet_name");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new FluidCabinetMenu(i, inventory, this);
    }

    private void notifyCanisterContentsChanged() {
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            this.setChanged();
        }
    }

    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void clearControllerPos() {
        this.controllerPos = null;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Nullable
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public boolean isLinkedToController() {
        return this.controllerPos != null;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    private static class FluidCabinetFluidHandler
    implements IFluidHandler {
        private final FluidCabinetBlockEntity cabinet;
        private final Direction side;

        public FluidCabinetFluidHandler(FluidCabinetBlockEntity cabinet, @Nullable Direction side) {
            this.cabinet = cabinet;
            this.side = side;
        }

        public int getTanks() {
            return 4;
        }

        public FluidStack getFluidInTank(int tank) {
            ResourceLocation fluidId;
            Fluid fluid;
            FluidCanisterItem.CanisterContents contents;
            if (tank < 0 || tank >= 4) {
                return FluidStack.EMPTY;
            }
            ItemStack canisterStack = this.cabinet.inventory.getStackInSlot(tank);
            if (canisterStack.getItem() instanceof FluidCanisterItem && (contents = (FluidCanisterItem.CanisterContents)canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value())) != null && contents.storedFluidId().isPresent() && (fluid = FluidHelper.getFluidFromId(fluidId = contents.storedFluidId().get())) != null) {
                return new FluidStack(fluid, contents.amount());
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Config.getMaxCanisterStorage();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return !stack.isEmpty() && FluidHelper.isValidFluid(stack.getFluid());
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || !FluidHelper.isValidFluid(resource.getFluid())) {
                return 0;
            }
            ResourceLocation fluidId = FluidHelper.getStillFluid(FluidHelper.getFluidId(resource.getFluid()));
            for (int i = 0; i < 4; ++i) {
                FluidCanisterItem.CanisterContents contents;
                ItemStack canisterStack = this.cabinet.inventory.getStackInSlot(i);
                if (canisterStack.isEmpty() || !(canisterStack.getItem() instanceof FluidCanisterItem) || (contents = (FluidCanisterItem.CanisterContents)canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value())) == null || !contents.storedFluidId().isEmpty() && !FluidHelper.areFluidsCompatible(contents.storedFluidId().get(), fluidId)) continue;
                int maxToAdd = Config.getMaxCanisterStorage() - contents.amount();
                int toAdd = Math.min(resource.getAmount(), maxToAdd);
                if (toAdd > 0 && action.execute()) {
                    FluidCanisterItem.CanisterContents newContents = new FluidCanisterItem.CanisterContents(Optional.of(fluidId), contents.amount() + toAdd);
                    canisterStack.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)newContents);
                    this.cabinet.notifyCanisterContentsChanged();
                }
                return toAdd;
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || !FluidHelper.isValidFluid(resource.getFluid())) {
                return FluidStack.EMPTY;
            }
            ResourceLocation fluidId = FluidHelper.getStillFluid(FluidHelper.getFluidId(resource.getFluid()));
            for (int i = 0; i < 4; ++i) {
                FluidCanisterItem.CanisterContents contents;
                ItemStack canisterStack = this.cabinet.inventory.getStackInSlot(i);
                if (canisterStack.isEmpty() || !(canisterStack.getItem() instanceof FluidCanisterItem) || (contents = (FluidCanisterItem.CanisterContents)canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value())) == null || !contents.storedFluidId().isPresent() || !FluidHelper.areFluidsCompatible(contents.storedFluidId().get(), fluidId)) continue;
                int toDrain = Math.min(resource.getAmount(), contents.amount());
                if (toDrain > 0 && action.execute()) {
                    FluidCanisterItem.CanisterContents newContents = new FluidCanisterItem.CanisterContents(contents.storedFluidId(), contents.amount() - toDrain);
                    canisterStack.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)newContents);
                    this.cabinet.notifyCanisterContentsChanged();
                }
                return new FluidStack(resource.getFluid(), toDrain);
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            for (int i = 0; i < 4; ++i) {
                ResourceLocation fluidId;
                Fluid fluid;
                FluidCanisterItem.CanisterContents contents;
                ItemStack canisterStack = this.cabinet.inventory.getStackInSlot(i);
                if (canisterStack.isEmpty() || !(canisterStack.getItem() instanceof FluidCanisterItem) || (contents = (FluidCanisterItem.CanisterContents)canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value())) == null || !contents.storedFluidId().isPresent() || contents.amount() <= 0 || (fluid = FluidHelper.getFluidFromId(fluidId = contents.storedFluidId().get())) == null) continue;
                int toDrain = Math.min(maxDrain, contents.amount());
                if (toDrain > 0 && action.execute()) {
                    FluidCanisterItem.CanisterContents newContents = new FluidCanisterItem.CanisterContents(contents.storedFluidId(), contents.amount() - toDrain);
                    canisterStack.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)newContents);
                    this.cabinet.notifyCanisterContentsChanged();
                }
                return new FluidStack(fluid, toDrain);
            }
            return FluidStack.EMPTY;
        }
    }

    private static class FluidCabinetItemHandler
    implements IItemHandler {
        private final FluidCabinetBlockEntity cabinet;
        private final Direction side;

        public FluidCabinetItemHandler(FluidCabinetBlockEntity cabinet, @Nullable Direction side) {
            this.cabinet = cabinet;
            this.side = side;
        }

        public int getSlots() {
            return 0;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 0;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    }
}

