/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.block.entity;

import com.blocklogic.realfilingreborn.block.custom.FilingIndexBlock;
import com.blocklogic.realfilingreborn.block.entity.FilingCabinetBlockEntity;
import com.blocklogic.realfilingreborn.block.entity.FluidCabinetBlockEntity;
import com.blocklogic.realfilingreborn.block.entity.ModBlockEntities;
import com.blocklogic.realfilingreborn.capability.FilingIndexFluidHandler;
import com.blocklogic.realfilingreborn.capability.FilingIndexItemHandler;
import com.blocklogic.realfilingreborn.config.Config;
import com.blocklogic.realfilingreborn.item.custom.DiamondRangeUpgrade;
import com.blocklogic.realfilingreborn.item.custom.IronRangeUpgrade;
import com.blocklogic.realfilingreborn.item.custom.NetheriteRangeUpgrade;
import com.blocklogic.realfilingreborn.screen.custom.FilingIndexMenu;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class FilingIndexBlockEntity
extends BlockEntity
implements MenuProvider {
    private final Set<BlockPos> linkedCabinets = ConcurrentHashMap.newKeySet();
    private final ReentrantReadWriteLock cabinetLock = new ReentrantReadWriteLock();
    private final Map<Direction, IItemHandler> handlers = new ConcurrentHashMap<Direction, IItemHandler>();
    private final Map<Direction, IFluidHandler> fluidHandlers = new ConcurrentHashMap<Direction, IFluidHandler>();
    private static final int MAX_HANDLER_CACHE_SIZE = 16;
    private final Map<BlockPos, Boolean> rangeCache = new ConcurrentHashMap<BlockPos, Boolean>();
    private volatile int lastKnownRange = -1;
    private volatile long lastRangeCacheTime = 0L;
    private static final long RANGE_CACHE_DURATION_MS = 5000L;
    private volatile boolean updateScheduled = false;
    private volatile long lastUpdateTime = 0L;
    private static final long MIN_UPDATE_INTERVAL_MS = 100L;
    public final ItemStackHandler inventory = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            FilingIndexBlockEntity.this.clearRangeCache();
            FilingIndexBlockEntity.this.setChanged();
            if (FilingIndexBlockEntity.this.level != null && !FilingIndexBlockEntity.this.level.isClientSide()) {
                FilingIndexBlockEntity.this.scheduleBlockUpdate();
            }
        }
    };

    public FilingIndexBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.FILING_INDEX_BE.get(), pos, blockState);
    }

    public boolean isInRange(BlockPos cabinetPos) {
        int currentRange = this.getRange();
        long currentTime = System.currentTimeMillis();
        if (currentRange != this.lastKnownRange || currentTime - this.lastRangeCacheTime > 5000L) {
            this.clearRangeCache();
            this.lastKnownRange = currentRange;
            this.lastRangeCacheTime = currentTime;
        }
        return this.rangeCache.computeIfAbsent(cabinetPos, pos -> {
            double rangeSq;
            double distSq = this.getBlockPos().distSqr((Vec3i)pos);
            return distSq <= (rangeSq = (double)currentRange * (double)currentRange);
        });
    }

    private void clearRangeCache() {
        this.rangeCache.clear();
        this.lastRangeCacheTime = 0L;
    }

    @Nullable
    public IItemHandler getCapabilityHandler(@Nullable Direction side) {
        if (this.handlers.size() > 16) {
            this.handlers.clear();
        }
        return this.handlers.computeIfAbsent(side != null ? side : Direction.UP, s -> new FilingIndexItemHandler(this));
    }

    @Nullable
    public IFluidHandler getFluidCapabilityHandler(@Nullable Direction side) {
        if (this.fluidHandlers.size() > 16) {
            this.fluidHandlers.clear();
        }
        return this.fluidHandlers.computeIfAbsent(side != null ? side : Direction.UP, s -> new FilingIndexFluidHandler(this));
    }

    public void drops() {
        this.clearAllLinkedCabinets();
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCabinet(BlockPos cabinetPos) {
        this.cabinetLock.writeLock().lock();
        try {
            boolean wasEmpty = this.linkedCabinets.isEmpty();
            boolean added = this.linkedCabinets.add(cabinetPos);
            if (added) {
                this.clearRangeCache();
                this.setChanged();
                if (this.level != null && !this.level.isClientSide()) {
                    this.scheduleBlockUpdate();
                    if (wasEmpty) {
                        this.scheduleConnectedStateUpdate();
                    }
                }
            }
        }
        finally {
            this.cabinetLock.writeLock().unlock();
        }
    }

    public void removeCabinet(BlockPos cabinetPos) {
        this.cabinetLock.writeLock().lock();
        try {
            boolean wasRemoved = this.linkedCabinets.remove(cabinetPos);
            if (wasRemoved) {
                this.clearRangeCache();
                this.setChanged();
                if (this.level != null && !this.level.isClientSide()) {
                    this.scheduleBlockUpdate();
                    if (this.linkedCabinets.isEmpty()) {
                        this.scheduleConnectedStateUpdate();
                    }
                }
            }
        }
        finally {
            this.cabinetLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCabinets(Set<BlockPos> cabinets) {
        if (cabinets.isEmpty()) {
            return;
        }
        this.cabinetLock.writeLock().lock();
        try {
            boolean wasEmpty = this.linkedCabinets.isEmpty();
            boolean changed = false;
            for (BlockPos cabinet : cabinets) {
                if (!this.linkedCabinets.add(cabinet)) continue;
                changed = true;
            }
            if (changed) {
                this.clearRangeCache();
                this.setChanged();
                if (this.level != null && !this.level.isClientSide()) {
                    this.scheduleBlockUpdate();
                    if (wasEmpty && !this.linkedCabinets.isEmpty()) {
                        this.scheduleConnectedStateUpdate();
                    }
                }
            }
        }
        finally {
            this.cabinetLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCabinets(Set<BlockPos> cabinets) {
        if (cabinets.isEmpty()) {
            return;
        }
        this.cabinetLock.writeLock().lock();
        try {
            boolean hadCabinets = !this.linkedCabinets.isEmpty();
            boolean changed = this.linkedCabinets.removeAll(cabinets);
            if (changed) {
                this.clearRangeCache();
                this.setChanged();
                if (this.level != null && !this.level.isClientSide()) {
                    this.scheduleBlockUpdate();
                    if (hadCabinets && this.linkedCabinets.isEmpty()) {
                        this.scheduleConnectedStateUpdate();
                    }
                }
            }
        }
        finally {
            this.cabinetLock.writeLock().unlock();
        }
    }

    private void scheduleBlockUpdate() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime > 100L) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            this.lastUpdateTime = currentTime;
        }
    }

    private void scheduleConnectedStateUpdate() {
        if (!this.updateScheduled && this.level != null && !this.level.isClientSide()) {
            this.updateScheduled = true;
            this.level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 1);
        }
    }

    public void performScheduledUpdate() {
        if (this.updateScheduled) {
            this.updateScheduled = false;
            this.updateConnectedStateImmediate();
        }
    }

    public Set<BlockPos> getLinkedCabinets() {
        this.cabinetLock.readLock().lock();
        try {
            HashSet<BlockPos> hashSet = new HashSet<BlockPos>(this.linkedCabinets);
            return hashSet;
        }
        finally {
            this.cabinetLock.readLock().unlock();
        }
    }

    public int getLinkedCabinetCount() {
        this.cabinetLock.readLock().lock();
        try {
            int n = this.linkedCabinets.size();
            return n;
        }
        finally {
            this.cabinetLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCabinetAt(BlockPos cabinetPos) {
        this.cabinetLock.writeLock().lock();
        try {
            if (this.linkedCabinets.remove(cabinetPos)) {
                this.clearRangeCache();
                if (this.level != null && !this.level.isClientSide()) {
                    BlockEntity blockEntity = this.level.getBlockEntity(cabinetPos);
                    if (blockEntity instanceof FilingCabinetBlockEntity) {
                        FilingCabinetBlockEntity cabinet = (FilingCabinetBlockEntity)blockEntity;
                        cabinet.clearControllerPos();
                    } else {
                        blockEntity = this.level.getBlockEntity(cabinetPos);
                        if (blockEntity instanceof FluidCabinetBlockEntity) {
                            FluidCabinetBlockEntity fluidCabinet = (FluidCabinetBlockEntity)blockEntity;
                            fluidCabinet.clearControllerPos();
                        }
                    }
                    this.scheduleBlockUpdate();
                    if (this.linkedCabinets.isEmpty()) {
                        this.scheduleConnectedStateUpdate();
                    }
                }
                this.setChanged();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.cabinetLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllLinkedCabinets() {
        this.cabinetLock.writeLock().lock();
        try {
            if (this.level != null && !this.level.isClientSide()) {
                for (BlockPos cabinetPos : this.linkedCabinets) {
                    BlockEntity blockEntity = this.level.getBlockEntity(cabinetPos);
                    if (blockEntity instanceof FilingCabinetBlockEntity) {
                        FilingCabinetBlockEntity cabinet = (FilingCabinetBlockEntity)blockEntity;
                        cabinet.clearControllerPos();
                        continue;
                    }
                    blockEntity = this.level.getBlockEntity(cabinetPos);
                    if (!(blockEntity instanceof FluidCabinetBlockEntity)) continue;
                    FluidCabinetBlockEntity fluidCabinet = (FluidCabinetBlockEntity)blockEntity;
                    fluidCabinet.clearControllerPos();
                }
            }
            boolean hadCabinets = !this.linkedCabinets.isEmpty();
            this.linkedCabinets.clear();
            this.clearRangeCache();
            this.setChanged();
            if (hadCabinets && this.level != null && !this.level.isClientSide()) {
                this.scheduleConnectedStateUpdate();
            }
        }
        finally {
            this.cabinetLock.writeLock().unlock();
        }
    }

    public int getRange() {
        ItemStack upgradeStack = this.inventory.getStackInSlot(0);
        if (upgradeStack.isEmpty()) {
            return Config.getFilingIndexBaseRange();
        }
        if (upgradeStack.getItem() instanceof NetheriteRangeUpgrade) {
            return Config.getNetheriteRangeUpgrade();
        }
        if (upgradeStack.getItem() instanceof DiamondRangeUpgrade) {
            return Config.getDiamondRangeUpgrade();
        }
        if (upgradeStack.getItem() instanceof IronRangeUpgrade) {
            return Config.getIronRangeUpgrade();
        }
        return Config.getFilingIndexBaseRange();
    }

    public void updateConnectedState() {
        this.scheduleConnectedStateUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnectedStateImmediate() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        BlockState currentState = this.getBlockState();
        if (!(currentState.getBlock() instanceof FilingIndexBlock)) {
            return;
        }
        this.cabinetLock.readLock().lock();
        try {
            boolean hasConnections = this.linkedCabinets.size() > 0;
            boolean currentlyConnected = (Boolean)currentState.getValue((Property)FilingIndexBlock.CONNECTED);
            if (hasConnections != currentlyConnected) {
                BlockState newState = (BlockState)currentState.setValue((Property)FilingIndexBlock.CONNECTED, (Comparable)Boolean.valueOf(hasConnections));
                this.level.setBlock(this.getBlockPos(), newState, 3);
            }
        }
        finally {
            this.cabinetLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        this.cabinetLock.readLock().lock();
        try {
            ListTag cabinetList = new ListTag();
            for (BlockPos cabinetPos : this.linkedCabinets) {
                cabinetList.add((Object)LongTag.valueOf((long)cabinetPos.asLong()));
            }
            tag.put("linkedCabinets", (Tag)cabinetList);
        }
        finally {
            this.cabinetLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.cabinetLock.writeLock().lock();
        try {
            this.linkedCabinets.clear();
            this.clearRangeCache();
            if (tag.contains("linkedCabinets")) {
                ListTag cabinetList = tag.getList("linkedCabinets", 4);
                for (int i = 0; i < cabinetList.size(); ++i) {
                    long posLong = ((LongTag)cabinetList.get(i)).getAsLong();
                    BlockPos cabinetPos = BlockPos.of((long)posLong);
                    this.linkedCabinets.add(cabinetPos);
                }
            }
        }
        finally {
            this.cabinetLock.writeLock().unlock();
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"blockentity.realfilingreborn.filing_index_name");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new FilingIndexMenu(i, inventory, this);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

