/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.block.custom;

import com.blocklogic.realfilingreborn.block.entity.FilingIndexBlockEntity;
import com.blocklogic.realfilingreborn.block.entity.FluidCabinetBlockEntity;
import com.blocklogic.realfilingreborn.item.custom.FluidCanisterItem;
import com.blocklogic.realfilingreborn.screen.custom.FluidCabinetMenu;
import com.blocklogic.realfilingreborn.util.FluidHelper;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FluidCabinetBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final MapCodec<FluidCabinetBlock> CODEC = FluidCabinetBlock.simpleCodec(FluidCabinetBlock::new);

    public FluidCabinetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new FluidCabinetBlockEntity(blockPos, blockState);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof FluidCabinetBlockEntity) {
            BlockEntity blockEntity2;
            FluidCabinetBlockEntity fluidCabinetBlockEntity = (FluidCabinetBlockEntity)blockEntity;
            BlockPos controllerPos = fluidCabinetBlockEntity.getControllerPos();
            if (controllerPos != null && (blockEntity2 = level.getBlockEntity(controllerPos)) instanceof FilingIndexBlockEntity) {
                FilingIndexBlockEntity indexEntity = (FilingIndexBlockEntity)blockEntity2;
                indexEntity.removeCabinet(pos);
            }
            fluidCabinetBlockEntity.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    private void openFluidCabinetMenu(FluidCabinetBlockEntity blockEntity, ServerPlayer player, BlockPos pos) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, playerEntity) -> new FluidCabinetMenu(id, inventory, blockEntity), (Component)Component.translatable((String)"menu.realfilingreborn.fluid_cabinet_menu_title")), pos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        FluidCabinetBlockEntity fluidCabinetBlockEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FluidCabinetBlockEntity) {
            fluidCabinetBlockEntity = (FluidCabinetBlockEntity)blockEntity;
            if (player.isCrouching()) {
                if (!level.isClientSide()) {
                    this.openFluidCabinetMenu(fluidCabinetBlockEntity, (ServerPlayer)player, pos);
                    level.playSound(player, pos, SoundEvents.VILLAGER_WORK_CARTOGRAPHER, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        if ((blockEntity = level.getBlockEntity(pos)) instanceof FluidCabinetBlockEntity) {
            fluidCabinetBlockEntity = (FluidCabinetBlockEntity)blockEntity;
            ItemStack heldItem = player.getItemInHand(hand);
            Direction facing = (Direction)state.getValue((Property)FACING);
            if (hitResult.getDirection() == facing && heldItem.getItem() == Items.BUCKET) {
                if (level.isClientSide()) {
                    return ItemInteractionResult.SUCCESS;
                }
                int targetSlot = this.getQuadFromHitResult(hitResult, facing);
                if (targetSlot >= 0 && targetSlot < 4) {
                    return this.extractFromSlot(fluidCabinetBlockEntity, targetSlot, player, level, pos, state);
                }
            }
            if (heldItem.getItem() instanceof FluidCanisterItem) {
                if (level.isClientSide()) {
                    return ItemInteractionResult.SUCCESS;
                }
                for (int i = 0; i < 4; ++i) {
                    if (!fluidCabinetBlockEntity.inventory.getStackInSlot(i).isEmpty()) continue;
                    ItemStack canisterStack = heldItem.copyWithCount(1);
                    fluidCabinetBlockEntity.inventory.setStackInSlot(i, canisterStack);
                    heldItem.shrink(1);
                    level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
                    level.sendBlockUpdated(pos, state, state, 2);
                    fluidCabinetBlockEntity.setChanged();
                    return ItemInteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.canisters_full"), true);
                return ItemInteractionResult.SUCCESS;
            }
            Item i = heldItem.getItem();
            if (i instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)i;
                if (bucketItem.content != Fluids.EMPTY) {
                    if (level.isClientSide()) {
                        return ItemInteractionResult.SUCCESS;
                    }
                    Fluid fluid = bucketItem.content;
                    ResourceLocation fluidId = fluid.builtInRegistryHolder().key().location();
                    for (int i2 = 0; i2 < 4; ++i2) {
                        int maxToAdd;
                        int toAdd;
                        FluidCanisterItem.CanisterContents contents;
                        ItemStack canisterStack = fluidCabinetBlockEntity.inventory.getStackInSlot(i2);
                        if (canisterStack.isEmpty() || !(canisterStack.getItem() instanceof FluidCanisterItem) || (contents = (FluidCanisterItem.CanisterContents)canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value())) == null) continue;
                        if (contents.storedFluidId().isEmpty()) {
                            FluidCanisterItem.CanisterContents newContents = new FluidCanisterItem.CanisterContents(Optional.of(fluidId), 1000);
                            canisterStack.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)newContents);
                            heldItem.shrink(1);
                            ItemStack emptyBucket = new ItemStack((ItemLike)Items.BUCKET);
                            if (!player.getInventory().add(emptyBucket)) {
                                player.drop(emptyBucket, false);
                            }
                            level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.5f);
                            level.sendBlockUpdated(pos, state, state, 2);
                            fluidCabinetBlockEntity.setChanged();
                            return ItemInteractionResult.SUCCESS;
                        }
                        if (!contents.storedFluidId().get().equals((Object)fluidId) || (toAdd = Math.min(1000, maxToAdd = Integer.MAX_VALUE - contents.amount())) < 1000) continue;
                        FluidCanisterItem.CanisterContents newContents = new FluidCanisterItem.CanisterContents(contents.storedFluidId(), contents.amount() + 1000);
                        canisterStack.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)newContents);
                        heldItem.shrink(1);
                        ItemStack emptyBucket = new ItemStack((ItemLike)Items.BUCKET);
                        if (!player.getInventory().add(emptyBucket)) {
                            player.drop(emptyBucket, false);
                        }
                        level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.5f);
                        level.sendBlockUpdated(pos, state, state, 2);
                        fluidCabinetBlockEntity.setChanged();
                        return ItemInteractionResult.SUCCESS;
                    }
                    player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.no_compatible_canister"), true);
                    return ItemInteractionResult.SUCCESS;
                }
            }
            if (!level.isClientSide()) {
                this.openFluidCabinetMenu(fluidCabinetBlockEntity, (ServerPlayer)player, pos);
                level.playSound(player, pos, SoundEvents.VILLAGER_WORK_CARTOGRAPHER, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    private int getQuadFromHitResult(BlockHitResult hitResult, Direction facing) {
        boolean isTop;
        double faceY;
        double faceX;
        Vec3 hitPos = hitResult.getLocation();
        double relativeX = hitPos.x - Math.floor(hitPos.x);
        double relativeY = hitPos.y - Math.floor(hitPos.y);
        double relativeZ = hitPos.z - Math.floor(hitPos.z);
        switch (facing) {
            case NORTH: {
                faceX = 1.0 - relativeX;
                faceY = relativeY;
                break;
            }
            case SOUTH: {
                faceX = relativeX;
                faceY = relativeY;
                break;
            }
            case EAST: {
                faceX = 1.0 - relativeZ;
                faceY = relativeY;
                break;
            }
            case WEST: {
                faceX = relativeZ;
                faceY = relativeY;
                break;
            }
            default: {
                return -1;
            }
        }
        boolean isLeft = faceX < 0.5;
        boolean bl = isTop = faceY > 0.5;
        if (isTop && isLeft) {
            return 0;
        }
        if (isTop && !isLeft) {
            return 1;
        }
        if (!isTop && isLeft) {
            return 2;
        }
        if (!isTop && !isLeft) {
            return 3;
        }
        return -1;
    }

    private ItemInteractionResult extractFromSlot(FluidCabinetBlockEntity blockEntity, int slot, Player player, Level level, BlockPos pos, BlockState state) {
        ItemStack canisterStack = blockEntity.inventory.getStackInSlot(slot);
        if (canisterStack.isEmpty() || !(canisterStack.getItem() instanceof FluidCanisterItem)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.no_fluid_in_slot"), true);
            return ItemInteractionResult.SUCCESS;
        }
        FluidCanisterItem.CanisterContents contents = (FluidCanisterItem.CanisterContents)canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value());
        if (contents == null || contents.storedFluidId().isEmpty() || contents.amount() < 1000) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.not_enough_fluid_in_slot"), true);
            return ItemInteractionResult.SUCCESS;
        }
        ResourceLocation fluidId = contents.storedFluidId().get();
        ItemStack bucketToGive = FluidHelper.getBucketForFluid(fluidId);
        if (bucketToGive.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.no_bucket_for_fluid"), true);
            return ItemInteractionResult.SUCCESS;
        }
        FluidCanisterItem.CanisterContents newContents = new FluidCanisterItem.CanisterContents(contents.storedFluidId(), contents.amount() - 1000);
        canisterStack.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)newContents);
        player.getItemInHand(InteractionHand.MAIN_HAND).shrink(1);
        if (!player.getInventory().add(bucketToGive)) {
            player.drop(bucketToGive, false);
        }
        level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.5f);
        level.sendBlockUpdated(pos, state, state, 2);
        blockEntity.setChanged();
        player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.fluid_extracted"), true);
        return ItemInteractionResult.SUCCESS;
    }

    private ItemStack getBucketForFluid(ResourceLocation fluidId) {
        if (fluidId.equals((Object)Fluids.WATER.builtInRegistryHolder().key().location())) {
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        if (fluidId.equals((Object)Fluids.LAVA.builtInRegistryHolder().key().location())) {
            return new ItemStack((ItemLike)Items.LAVA_BUCKET);
        }
        try {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluidId);
            if (fluid != null && fluid != Fluids.EMPTY) {
                for (Item item : BuiltInRegistries.ITEM) {
                    if (!(item instanceof BucketItem)) continue;
                    BucketItem bucketItem = (BucketItem)item;
                    if (bucketItem.content != fluid) continue;
                    return new ItemStack((ItemLike)item);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ItemStack.EMPTY;
    }
}

