/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.block.custom;

import com.blocklogic.realfilingreborn.block.custom.FilingCabinetBlock;
import com.blocklogic.realfilingreborn.block.entity.FilingIndexBlockEntity;
import com.blocklogic.realfilingreborn.component.LedgerData;
import com.blocklogic.realfilingreborn.component.ModDataComponents;
import com.blocklogic.realfilingreborn.item.custom.LedgerItem;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FilingIndexBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final MapCodec<FilingCabinetBlock> CODEC = FilingIndexBlock.simpleCodec(FilingCabinetBlock::new);
    public static final BooleanProperty CONNECTED = BooleanProperty.create((String)"connected");

    public FilingIndexBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CONNECTED});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new FilingIndexBlockEntity(blockPos, blockState);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FilingIndexBlockEntity) {
            FilingIndexBlockEntity indexEntity = (FilingIndexBlockEntity)blockEntity;
            indexEntity.performScheduledUpdate();
        }
    }

    public static void updateConnectedState(Level level, BlockPos pos) {
        boolean currentlyConnected;
        FilingIndexBlockEntity indexEntity;
        boolean hasConnections;
        if (level.isClientSide()) {
            return;
        }
        BlockState currentState = level.getBlockState(pos);
        if (!(currentState.getBlock() instanceof FilingIndexBlock)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FilingIndexBlockEntity && (hasConnections = (indexEntity = (FilingIndexBlockEntity)blockEntity).getLinkedCabinetCount() > 0) != (currentlyConnected = ((Boolean)currentState.getValue((Property)CONNECTED)).booleanValue())) {
            BlockState newState = (BlockState)currentState.setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(hasConnections));
            level.setBlock(pos, newState, 3);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof FilingIndexBlockEntity) {
            FilingIndexBlockEntity filingIndexBlockEntity = (FilingIndexBlockEntity)blockEntity;
            filingIndexBlockEntity.clearAllLinkedCabinets();
            this.clearControllerFromNearbyLedgers(level, pos);
            filingIndexBlockEntity.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    private void clearControllerFromNearbyLedgers(Level level, BlockPos controllerPos) {
        if (level.isClientSide()) {
            return;
        }
        level.players().forEach(player -> {
            if (player.distanceToSqr((double)controllerPos.getX(), (double)controllerPos.getY(), (double)controllerPos.getZ()) <= 4096.0) {
                this.clearControllerFromPlayerLedgers((Player)player, controllerPos);
            }
        });
    }

    private void clearControllerFromPlayerLedgers(Player player, BlockPos controllerPos) {
        ItemStack offHand;
        ItemStack mainHand = player.getMainHandItem();
        if (mainHand.getItem() instanceof LedgerItem) {
            this.clearControllerFromLedger(mainHand, controllerPos, player);
        }
        if ((offHand = player.getOffhandItem()).getItem() instanceof LedgerItem) {
            this.clearControllerFromLedger(offHand, controllerPos, player);
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!(stack.getItem() instanceof LedgerItem)) continue;
            this.clearControllerFromLedger(stack, controllerPos, player);
        }
    }

    private void clearControllerFromLedger(ItemStack ledgerStack, BlockPos controllerPos, Player player) {
        LedgerData data = (LedgerData)ledgerStack.getOrDefault((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)LedgerData.DEFAULT);
        if (data.selectedController() != null && data.selectedController().equals((Object)controllerPos)) {
            LedgerData newData = data.withSelectedController(null);
            ledgerStack.set((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)newData);
            MutableComponent message = Component.translatable((String)"item.realfilingreborn.ledger.controller.cleared");
            player.displayClientMessage((Component)message, true);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FilingIndexBlockEntity) {
            FilingIndexBlockEntity filingIndexBlockEntity = (FilingIndexBlockEntity)blockEntity;
            if (!level.isClientSide()) {
                ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)filingIndexBlockEntity, (Component)Component.translatable((String)"menu.realfilingreborn.filing_index")), pos);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }
}

