/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.network.handler;

import com.maciej916.overenchanted.data.ModDataAttachments;
import com.maciej916.overenchanted.data.impl.PlayerDataAttachment;
import com.maciej916.overenchanted.data.impl.ScheduledTask;
import com.maciej916.overenchanted.network.payload.EchoSightPayload;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class EchoSightPayloadHandler {
    public static void handleDataOnNetwork(EchoSightPayload data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player.hasData(ModDataAttachments.PLAYER_DATA)) {
                PlayerDataAttachment playerDataAttachment = (PlayerDataAttachment)player.getData(ModDataAttachments.PLAYER_DATA);
                if (playerDataAttachment.getRevealCountdown() > 0) {
                    player.displayClientMessage((Component)Component.translatable((String)"overenchanted.echo_sight_countdown", (Object[])new Object[]{Component.literal((String)("" + playerDataAttachment.getRevealCountdown()))}).withStyle(ChatFormatting.RED), true);
                } else {
                    ServerLevel serverLevel = (ServerLevel)player.level();
                    int duration = 80;
                    player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, duration + 20, 0, false, false));
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration, 3, false, false));
                    player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, duration, 100, false, false));
                    serverLevel.playSound(null, player.getOnPos(), SoundEvents.WARDEN_SONIC_CHARGE, SoundSource.PLAYERS, 1.0f, 1.0f);
                    playerDataAttachment.scheduleTask(new ScheduledTask(serverLevel.getServer().getTickCount() + 80, () -> {
                        EchoSightPayloadHandler.spawnRevealParticles(serverLevel, player);
                        serverLevel.playSound(null, player.getOnPos(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.PLAYERS, 1.0f, 1.0f);
                        int RANGE = 15 * data.level();
                        List nearbyEntities = serverLevel.getEntitiesOfClass(Monster.class, player.getBoundingBox().inflate((double)RANGE));
                        for (Monster nearbyEntity : nearbyEntities) {
                            nearbyEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 100, false, false));
                        }
                    }));
                    playerDataAttachment.setRevealCountdown(30);
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"overenchanted.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    private static void spawnRevealParticles(ServerLevel serverLevel, Player player) {
        double d0 = serverLevel.random.nextGaussian() * 0.02;
        double d1 = serverLevel.random.nextGaussian() * 0.02;
        double d2 = serverLevel.random.nextGaussian() * 0.02;
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, player.getX(), player.getEyeY() - 1.0, player.getZ(), 1, d0, d1, d2, 0.0);
    }
}

