/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.loot;

import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ChestLootProvider
implements LootTableSubProvider {
    public static final String COMMON_LOOT_TABLE_NAME = "chests/common_loot";
    public static final String ALLOY_LOOT_TABLE_NAME = "chests/alloy_loot";
    private final HolderLookup.Provider registries;

    public ChestLootProvider(HolderLookup.Provider registries) {
        this.registries = registries;
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> writer) {
        this.generateCommonLoot(writer);
    }

    private void generateCommonLoot(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> writer) {
        LootPool.Builder lootPool = LootPool.lootPool().name("Overenchanted").setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f));
        LootTable.Builder lootTable = LootTable.lootTable().withPool(lootPool).setParamSet(LootContextParamSets.CHEST);
        writer.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"overenchanted", (String)COMMON_LOOT_TABLE_NAME)), lootTable);
    }
}

