/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.enchantment.impl;

import com.maciej916.overenchanted.enchantment.ModEnchantments;
import com.maciej916.overenchanted.tag.ModTags;
import com.maciej916.overenchanted.util.EnchantmentRarity;
import com.maciej916.overenchanted.util.EnchantmentUtil;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="overenchanted", bus=EventBusSubscriber.Bus.GAME)
public class SonicBoomProtectionEnchantment {
    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        SonicBoomProtectionEnchantment.execute(event, event.getEntity(), event.getSource());
    }

    private static void execute(LivingDamageEvent.Pre event, LivingEntity entity, DamageSource source) {
        if (source.is(DamageTypes.SONIC_BOOM) && entity instanceof Player) {
            Player player = (Player)entity;
            int totalLevel = 0;
            for (ItemStack itemStack : player.getArmorSlots()) {
                int lvl = EnchantmentUtil.getEnchantmentLevel((LevelAccessor)player.level(), itemStack, ModEnchantments.SONIC_BOOM_PROTECTION);
                totalLevel += lvl;
            }
            if (totalLevel > 0) {
                if (totalLevel >= 16) {
                    event.setNewDamage(0.0f);
                } else {
                    float reductionFactor = 1.0f - (float)totalLevel / 16.0f;
                    float newDamage = event.getOriginalDamage() * reductionFactor;
                    event.setNewDamage(newDamage);
                }
            }
        }
    }

    public static Enchantment.Builder builder(BootstrapContext<Enchantment> context) {
        HolderGetter items = context.lookup(Registries.ITEM);
        return Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ModTags.Items.SONIC_BOOM_ENCHANTABLE), (int)EnchantmentRarity.RARE.weight(), (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)6, (int)9), (Enchantment.Cost)Enchantment.dynamicCost((int)14, (int)9), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR}));
    }
}

