/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.enchantment.impl;

import com.maciej916.overenchanted.capability.ModCapabilities;
import com.maciej916.overenchanted.capability.impl.IRicochetArrowCapability;
import com.maciej916.overenchanted.enchantment.ModEnchantments;
import com.maciej916.overenchanted.network.payload.RicochetArrowPayload;
import com.maciej916.overenchanted.util.EnchantmentRarity;
import com.maciej916.overenchanted.util.EnchantmentUtil;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="overenchanted", bus=EventBusSubscriber.Bus.GAME)
public class RicochetEnchantment {
    private static final double SPEED_DAMPENING = 0.7;
    private static final double ANGLE_VARIATION = 0.1;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onArrowJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractArrow) {
            IRicochetArrowCapability capability;
            AbstractArrow abstractArrow = (AbstractArrow)entity;
            ItemStack weaponItem = abstractArrow.getWeaponItem();
            int lvl = EnchantmentUtil.getEnchantmentLevel((LevelAccessor)event.getLevel(), weaponItem, ModEnchantments.RICOCHET);
            if (lvl > 0 && (capability = (IRicochetArrowCapability)abstractArrow.getCapability(ModCapabilities.RICOCHET_ARROW)) != null) {
                capability.setEntityId(abstractArrow.getId());
                capability.setBouncesLeft(lvl);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onParticleImpact(ProjectileImpactEvent event) {
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            Entity entity = event.getEntity();
            if (entity instanceof AbstractArrow) {
                AbstractArrow abstractArrow = (AbstractArrow)entity;
                Level level = abstractArrow.level();
                IRicochetArrowCapability capability = (IRicochetArrowCapability)abstractArrow.getCapability(ModCapabilities.RICOCHET_ARROW);
                if (capability != null && capability.getBouncesLeft() > 0) {
                    if (!level.isClientSide()) {
                        Direction facing = ((BlockHitResult)event.getRayTraceResult()).getDirection();
                        Vec3 arrowMotion = abstractArrow.getDeltaMovement();
                        switch (facing) {
                            case UP: 
                            case DOWN: {
                                arrowMotion = new Vec3(arrowMotion.x, -arrowMotion.y, arrowMotion.z);
                                break;
                            }
                            case EAST: 
                            case WEST: {
                                arrowMotion = new Vec3(-arrowMotion.x, arrowMotion.y, arrowMotion.z);
                                break;
                            }
                            case NORTH: 
                            case SOUTH: {
                                arrowMotion = new Vec3(arrowMotion.x, arrowMotion.y, -arrowMotion.z);
                            }
                        }
                        arrowMotion = arrowMotion.scale(0.7);
                        double variationX = (level.random.nextDouble() - 0.5) * 0.1;
                        double variationY = (level.random.nextDouble() - 0.5) * 0.1;
                        double variationZ = (level.random.nextDouble() - 0.5) * 0.1;
                        arrowMotion = arrowMotion.add(variationX, variationY, variationZ);
                        abstractArrow.setDeltaMovement(arrowMotion);
                        float yRot = abstractArrow.getYRot() + (float)(level.random.nextDouble() * 10.0 - 5.0);
                        float xRot = abstractArrow.getXRot() + (float)(level.random.nextDouble() * 5.0 - 2.5);
                        abstractArrow.setYRot(yRot);
                        abstractArrow.setXRot(xRot);
                        capability.setMotion(arrowMotion);
                        capability.setYRot(yRot);
                        capability.setXRot(xRot);
                        capability.setBouncesLeft(capability.getBouncesLeft() - 1);
                        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)abstractArrow, (CustomPacketPayload)new RicochetArrowPayload(abstractArrow.getId(), arrowMotion.toVector3f(), yRot, xRot, capability.getBouncesLeft()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    public static Enchantment.Builder builder(BootstrapContext<Enchantment> context) {
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        HolderGetter items = context.lookup(Registries.ITEM);
        return Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.BOW_ENCHANTABLE), (int)EnchantmentRarity.COMMON.weight(), (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)2, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)18, (int)10), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).exclusiveWith((HolderSet)enchantments.getOrThrow(EnchantmentTags.BOW_EXCLUSIVE));
    }
}

