/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.enchantment.impl;

import com.maciej916.overenchanted.enchantment.ModEnchantments;
import com.maciej916.overenchanted.tag.ModTags;
import com.maciej916.overenchanted.util.EnchantmentRarity;
import com.maciej916.overenchanted.util.EnchantmentUtil;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="overenchanted", bus=EventBusSubscriber.Bus.GAME)
public class ReinforcedTipEnchantment {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockBreak(PlayerEvent.BreakSpeed event) {
        ReinforcedTipEnchantment.execute(event, event.getOriginalSpeed(), event.getEntity(), event.getState());
    }

    private static void execute(PlayerEvent.BreakSpeed event, float originalSpeed, Player player, BlockState blockState) {
        if (blockState.is(ModTags.Blocks.REINFORCED_TIP_BLOCKS)) {
            ItemStack stack = player.getItemInHand(player.getUsedItemHand());
            if (!stack.isDamageableItem()) {
                return;
            }
            int lvl = EnchantmentUtil.getEnchantmentLevel((LevelAccessor)player.level(), stack, ModEnchantments.REINFORCED_TIP);
            if (lvl > 0) {
                event.setNewSpeed(originalSpeed * (float)lvl + 1.0f);
            }
        }
    }

    public static Enchantment.Builder builder(BootstrapContext<Enchantment> context) {
        HolderGetter items = context.lookup(Registries.ITEM);
        return Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.MINING_ENCHANTABLE), (int)EnchantmentRarity.RARE.weight(), (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)15, (int)9), (Enchantment.Cost)Enchantment.dynamicCost((int)65, (int)9), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND}));
    }
}

