/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.enchantment.impl;

import com.maciej916.overenchanted.enchantment.ModEnchantments;
import com.maciej916.overenchanted.network.payload.ReflectArrowPayload;
import com.maciej916.overenchanted.tag.ModTags;
import com.maciej916.overenchanted.util.EnchantmentRarity;
import com.maciej916.overenchanted.util.EnchantmentUtil;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="overenchanted", bus=EventBusSubscriber.Bus.GAME)
public class ReflectEnchantment {
    private static final double REFLECT_SCALE_SPEED = 5.0;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onParticleImpact(ProjectileImpactEvent event) {
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity targetEntity = entityHitResult.getEntity();
            Entity entity = event.getEntity();
            if (entity instanceof AbstractArrow) {
                AbstractArrow abstractArrow = (AbstractArrow)entity;
                if (targetEntity instanceof Player) {
                    Player player = (Player)targetEntity;
                    Level level = abstractArrow.level();
                    ItemStack useItemStack = player.getUseItem();
                    if (useItemStack.is(ModTags.Items.REFLECT_ENCHANTABLE)) {
                        int lvl = EnchantmentUtil.getEnchantmentLevel((LevelAccessor)level, useItemStack, ModEnchantments.REFLECT);
                        if (player.isUsingItem() && lvl > 0 && !level.isClientSide()) {
                            Vec3 arrowMotion = abstractArrow.getDeltaMovement();
                            double scaleFactor = 5.0 * (double)lvl;
                            arrowMotion = arrowMotion.normalize().scale(arrowMotion.length() * scaleFactor);
                            abstractArrow.setDeltaMovement(arrowMotion);
                            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)abstractArrow, (CustomPacketPayload)new ReflectArrowPayload(abstractArrow.getId(), arrowMotion.toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    }
                }
            }
        }
    }

    public static Enchantment.Builder builder(BootstrapContext<Enchantment> context) {
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        HolderGetter items = context.lookup(Registries.ITEM);
        return Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ModTags.Items.REFLECT_ENCHANTABLE), (int)EnchantmentRarity.COMMON.weight(), (int)2, (Enchantment.Cost)Enchantment.dynamicCost((int)2, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)18, (int)10), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND}));
    }
}

