/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.enchantment.impl;

import com.maciej916.overenchanted.data.ModDataAttachments;
import com.maciej916.overenchanted.data.impl.PlayerDataAttachment;
import com.maciej916.overenchanted.enchantment.ModEnchantments;
import com.maciej916.overenchanted.tag.ModTags;
import com.maciej916.overenchanted.util.EnchantmentRarity;
import com.maciej916.overenchanted.util.EnchantmentUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="overenchanted", bus=EventBusSubscriber.Bus.GAME)
public class LumberjackEnchantment {
    private static final int MAX_TREE_SIZE = 512;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        LumberjackEnchantment.execute(event, event.getState(), event.getPos(), event.getPlayer());
    }

    private static void execute(BlockEvent.BreakEvent event, BlockState blockState, BlockPos pos, Player player) {
        if (blockState.is(ModTags.Blocks.LUMBERJACK_BLOCKS)) {
            Level level;
            Set<BlockPos> treeBlocks;
            PlayerDataAttachment playerDataAttachment;
            ItemStack stack = player.getItemInHand(player.getUsedItemHand());
            int lvl = EnchantmentUtil.getEnchantmentLevel((LevelAccessor)player.level(), stack, ModEnchantments.LUMBERJACK);
            if (lvl > 0 && player.hasData(ModDataAttachments.PLAYER_DATA) && (playerDataAttachment = (PlayerDataAttachment)player.getData(ModDataAttachments.PLAYER_DATA)).isLumberjackActive() && (treeBlocks = LumberjackEnchantment.findTree(level = player.level(), pos, blockState)).size() <= 512) {
                LumberjackEnchantment.doBreak(player, level, pos, treeBlocks, stack);
                event.setCanceled(true);
            }
        }
    }

    private static void doBreak(Player player, Level level, BlockPos pos, Set<BlockPos> treeBlocks, ItemStack stack) {
        Block block = level.getBlockState(pos).getBlock();
        int logsToBreak = stack.isDamageableItem() ? Math.min(512, stack.getDamageValue()) : 512;
        int logsBroken = 0;
        for (BlockPos point : treeBlocks) {
            if (logsBroken > logsToBreak) break;
            level.setBlock(point, Blocks.AIR.defaultBlockState(), 3);
            ++logsBroken;
        }
        if (logsBroken > 0) {
            ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)block, logsBroken));
            level.addFreshEntity((Entity)item);
            if (!player.isCreative() && !player.isSpectator()) {
                stack.hurtAndBreak(logsBroken, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            }
        }
    }

    private static Set<BlockPos> findTree(Level level, BlockPos start, BlockState state) {
        HashSet<BlockPos> treeBlocks = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(start);
        while (!queue.isEmpty() && treeBlocks.size() <= 512) {
            BlockState currentState;
            BlockPos pos = (BlockPos)queue.poll();
            if (treeBlocks.contains(pos) || (currentState = level.getBlockState(pos)).getBlock() != state.getBlock()) continue;
            treeBlocks.add(pos);
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                    for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                        BlockPos newPos = pos.offset(offsetX, offsetY, offsetZ);
                        if (treeBlocks.contains(newPos)) continue;
                        queue.add(newPos);
                    }
                }
            }
        }
        return treeBlocks;
    }

    public static Enchantment.Builder builder(BootstrapContext<Enchantment> context) {
        HolderGetter items = context.lookup(Registries.ITEM);
        return Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ModTags.Items.LUMBERJACK_ENCHANTABLE), (int)EnchantmentRarity.VERY_RARE.weight(), (int)1, (Enchantment.Cost)Enchantment.constantCost((int)15), (Enchantment.Cost)Enchantment.constantCost((int)65), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND}));
    }
}

