/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.enchantment.impl;

import com.maciej916.overenchanted.enchantment.ModEnchantments;
import com.maciej916.overenchanted.tag.ModTags;
import com.maciej916.overenchanted.util.EnchantmentUtil;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.item.ItemExpireEvent;

@EventBusSubscriber(modid="overenchanted", bus=EventBusSubscriber.Bus.GAME)
public class EternalEnchantment {
    @SubscribeEvent
    public static void onItemExpire(ItemExpireEvent event) {
        EternalEnchantment.execute(event, event.getEntity());
    }

    private static void execute(ItemExpireEvent event, ItemEntity itemEntity) {
        int lvl = EnchantmentUtil.getEnchantmentLevel((LevelAccessor)itemEntity.level(), itemEntity.getItem(), ModEnchantments.ETERNAL);
        if (lvl > 0) {
            event.getEntity().setUnlimitedLifetime();
        }
    }

    public static Enchantment.Builder builder(BootstrapContext<Enchantment> context) {
        HolderGetter items = context.lookup(Registries.ITEM);
        return Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ModTags.Items.ETERNAL_ENCHANTABLE), (int)25, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)7), (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)75), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY}));
    }
}

