/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.enchantment.impl;

import com.maciej916.overenchanted.data.ModDataComponents;
import com.maciej916.overenchanted.enchantment.effect.ComboEnchantmentEffect;
import com.maciej916.overenchanted.util.EnchantmentRarity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="overenchanted", bus=EventBusSubscriber.Bus.GAME)
public class ComboEnchantment {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.has(ModDataComponents.COMBO)) {
            int comboLevel = (Integer)stack.getOrDefault(ModDataComponents.COMBO, (Object)0);
            ChatFormatting color = comboLevel < 50 ? ChatFormatting.RED : (comboLevel < 99 ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
            event.getToolTip().add(Component.translatable((String)"overenchanted.combo_lvl", (Object[])new Object[]{Component.literal((String)(comboLevel + "/100")).withStyle(color)}).withStyle(ChatFormatting.GRAY));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (stack.has(ModDataComponents.COMBO)) {
            stack.set(ModDataComponents.COMBO, (Object)0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (stack.has(ModDataComponents.COMBO)) {
            stack.set(ModDataComponents.COMBO, (Object)0);
        }
    }

    public static Enchantment.Builder builder(BootstrapContext<Enchantment> context) {
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        HolderGetter items = context.lookup(Registries.ITEM);
        HolderGetter entities = context.lookup(Registries.ENTITY_TYPE);
        return Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.WEAPON_ENCHANTABLE), (HolderSet)items.getOrThrow(ItemTags.SWORD_ENCHANTABLE), (int)EnchantmentRarity.VERY_RARE.weight(), (int)1, (Enchantment.Cost)Enchantment.constantCost((int)15), (Enchantment.Cost)Enchantment.constantCost((int)65), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).exclusiveWith((HolderSet)enchantments.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, (Object)new ComboEnchantmentEffect());
    }
}

