/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;

public record IncreaseDamageEffect(LevelBasedValue chance) implements EnchantmentValueEffect
{
    public static final MapCodec<IncreaseDamageEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("chance").forGetter(IncreaseDamageEffect::chance)).apply((Applicative)instance, IncreaseDamageEffect::new));

    public float process(int level, RandomSource random, float damage) {
        float f = this.chance.calculate(level);
        int increasedDamage = 0;
        int j = 0;
        while ((float)j < damage) {
            if (random.nextFloat() < f) {
                ++increasedDamage;
            }
            ++j;
        }
        return damage + (float)increasedDamage;
    }

    public MapCodec<IncreaseDamageEffect> codec() {
        return CODEC;
    }
}

