/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.enchantment.effect;

import com.maciej916.overenchanted.util.EntityUtil;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record BlazingEdgeEnchantmentEffect() implements EnchantmentEntityEffect
{
    public static final MapCodec<BlazingEdgeEnchantmentEffect> CODEC = MapCodec.unit(BlazingEdgeEnchantmentEffect::new);

    public void apply(ServerLevel serverLevel, int enchantmentLevel, EnchantedItemInUse enchantedItemInUse, Entity entity, Vec3 vec3) {
        int RANGE = 3;
        List nearbyEntities = serverLevel.getEntitiesOfClass(Monster.class, entity.getBoundingBox().inflate((double)RANGE));
        for (Monster nearbyEntity : nearbyEntities) {
            int random;
            if (!EntityUtil.hasLineOfSight(entity, (LivingEntity)nearbyEntity, serverLevel) || (random = serverLevel.random.nextInt(100)) >= 10 * enchantmentLevel) continue;
            this.igniteEntity((LivingEntity)nearbyEntity, enchantmentLevel);
        }
    }

    private void igniteEntity(LivingEntity entity, int enchantmentLevel) {
        entity.igniteForSeconds((float)enchantmentLevel);
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

