/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.datagen;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.AddTableLootModifier;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;

public class ModGlobalLootModifierProvider
extends GlobalLootModifierProvider {
    public ModGlobalLootModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "overenchanted");
    }

    protected void start() {
        this.modifyChestLoot("simple_dungeon", Stream.of("chests/simple_dungeon"));
    }

    private void modifyChestLoot(String lootTableName, Stream<String> targets) {
        LootTableIdCondition.Builder[] mappedTargetConditions = (LootTableIdCondition.Builder[])targets.map(r -> LootTableIdCondition.builder((ResourceLocation)ResourceLocation.parse((String)r))).toArray(LootTableIdCondition.Builder[]::new);
        this.add(lootTableName, (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{AnyOfCondition.anyOf((LootItemCondition.Builder[])mappedTargetConditions).build()}, ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ModGlobalLootModifierProvider.name(lootTableName))), new ICondition[0]);
    }

    private static ResourceLocation name(String lootTableName) {
        return ResourceLocation.fromNamespaceAndPath((String)"overenchanted", (String)("chests/" + lootTableName));
    }
}

