/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.data.impl;

import com.maciej916.overenchanted.data.impl.IPlayerDataAttachment;
import com.maciej916.overenchanted.data.impl.ScheduledTask;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.UnknownNullability;

public class PlayerDataAttachment
implements IPlayerDataAttachment {
    private final List<ScheduledTask> scheduledTasks = new LinkedList<ScheduledTask>();
    private int currentTick = 0;
    private int revealCountdown = 0;
    private boolean lumberjackActive = false;

    @Override
    public int getRevealCountdown() {
        return this.revealCountdown;
    }

    @Override
    public void setRevealCountdown(int seconds) {
        this.revealCountdown = seconds;
    }

    @Override
    public boolean isLumberjackActive() {
        return this.lumberjackActive;
    }

    @Override
    public void setLumberjackActive(boolean isActive) {
        this.lumberjackActive = isActive;
    }

    private void decreaseCooldowns() {
        if (this.revealCountdown > 0) {
            --this.revealCountdown;
        }
    }

    @Override
    public void tick(int tickCount) {
        ++this.currentTick;
        if (this.currentTick % 20 == 0) {
            this.currentTick = 0;
        }
        if (this.currentTick == 0) {
            this.decreaseCooldowns();
        }
        Iterator<ScheduledTask> iterator = this.scheduledTasks.iterator();
        while (iterator.hasNext()) {
            ScheduledTask task = iterator.next();
            if (task.getOnTick() > tickCount) continue;
            task.run();
            iterator.remove();
        }
    }

    @Override
    public void scheduleTask(ScheduledTask task) {
        this.scheduledTasks.add(task);
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("revealCountdown", this.revealCountdown);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        this.revealCountdown = compoundTag.getInt("revealCountdown");
    }
}

