/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.overenchanted.block.impl;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class MeltedCobblestoneBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;

    public MeltedCobblestoneBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(6.0f).sound(SoundType.STONE).isValidSpawn(Blocks::never));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)level.getRandom(), (int)60, (int)120));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((random.nextInt(3) == 0 || this.fewerNeigboursThan((BlockGetter)level, pos, 4)) && level.getMaxLocalRawBrightness(pos) > 11 - (Integer)state.getValue((Property)AGE) - state.getLightBlock((BlockGetter)level, pos) && this.slightlyMelt(state, (Level)level, pos)) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
                BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
                if (!blockstate.is((Block)this) || this.slightlyMelt(blockstate, (Level)level, (BlockPos)blockpos$mutableblockpos)) continue;
                level.scheduleTick((BlockPos)blockpos$mutableblockpos, (Block)this, Mth.nextInt((RandomSource)random, (int)20, (int)40));
            }
        } else {
            level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)random, (int)20, (int)40));
        }
    }

    private boolean slightlyMelt(BlockState state, Level level, BlockPos pos) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 3) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        this.melt(state, level, pos);
        return true;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (block.defaultBlockState().is((Block)this) && this.fewerNeigboursThan((BlockGetter)level, pos, 2)) {
            this.melt(state, level, pos);
        }
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
    }

    private boolean fewerNeigboursThan(BlockGetter level, BlockPos pos, int neighborsRequired) {
        int i = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
            if (!level.getBlockState((BlockPos)blockpos$mutableblockpos).is((Block)this) || ++i < neighborsRequired) continue;
            return false;
        }
        return true;
    }

    public static BlockState meltsInto() {
        return Blocks.LAVA.defaultBlockState();
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(level, player, pos, state, te, stack);
        if (!EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)EnchantmentTags.PREVENTS_ICE_MELTING)) {
            if (level.dimensionType().ultraWarm()) {
                level.removeBlock(pos, false);
                return;
            }
            BlockState blockstate = level.getBlockState(pos.below());
            if (blockstate.blocksMotion() || blockstate.liquid()) {
                level.setBlockAndUpdate(pos, MeltedCobblestoneBlock.meltsInto());
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return ItemStack.EMPTY;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.getBrightness(LightLayer.BLOCK, pos) > 11 - state.getLightBlock((BlockGetter)level, pos)) {
            this.melt(state, (Level)level, pos);
        }
    }

    protected void melt(BlockState state, Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, MeltedCobblestoneBlock.meltsInto());
        level.neighborChanged(pos, MeltedCobblestoneBlock.meltsInto().getBlock(), pos);
    }
}

