/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import com.klikli_dev.occultism.common.item.armor.OtherworldGogglesItem;
import com.klikli_dev.occultism.common.item.storage.EnderSatchelItem;
import com.klikli_dev.occultism.common.item.storage.SatchelItem;
import com.klikli_dev.occultism.common.item.storage.StorageRemoteItem;
import com.klikli_dev.occultism.registry.OccultismItems;
import java.util.Collection;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosUtil {
    public static boolean hasGoggles(Player player) {
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        if (OtherworldGogglesItem.isGogglesItem(helmet)) {
            return true;
        }
        ICuriosItemHandler curiosHandler = (ICuriosItemHandler)player.getCapability(CuriosCapability.INVENTORY);
        if (curiosHandler == null) {
            return false;
        }
        Collection slotsHandler = curiosHandler.getCurios().values();
        return slotsHandler.stream().map(ICurioStacksHandler::getStacks).anyMatch(stackHandler -> {
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack = stackHandler.getStackInSlot(i);
                if (!OtherworldGogglesItem.isGogglesItem(stack)) continue;
                return true;
            }
            return false;
        });
    }

    public static boolean hasStaff(Player player) {
        if (player.getOffhandItem().is(OccultismItems.TRUE_SIGHT_STAFF)) {
            return true;
        }
        ICuriosItemHandler curiosHandler = (ICuriosItemHandler)player.getCapability(CuriosCapability.INVENTORY);
        if (curiosHandler == null) {
            return false;
        }
        Collection slotsHandler = curiosHandler.getCurios().values();
        return slotsHandler.stream().map(ICurioStacksHandler::getStacks).anyMatch(stackHandler -> {
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack = stackHandler.getStackInSlot(i);
                if (!stack.is(OccultismItems.TRUE_SIGHT_STAFF)) continue;
                return true;
            }
            return false;
        });
    }

    public static ItemStack getBackpack(Player player) {
        ICuriosItemHandler curiosHandler = (ICuriosItemHandler)player.getCapability(CuriosCapability.INVENTORY);
        if (curiosHandler == null) {
            return ItemStack.EMPTY;
        }
        for (String curio : curiosHandler.getCurios().keySet()) {
            ItemStack stack = CuriosUtil.getSatchelItemFromSlot(curiosHandler, curio);
            if (stack.isEmpty()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    protected static ItemStack getSatchelItemFromSlot(ICuriosItemHandler curiosHandler, String identifier) {
        ICurioStacksHandler slotHandler = curiosHandler.getStacksHandler(identifier).orElse(null);
        if (slotHandler == null) {
            return ItemStack.EMPTY;
        }
        IDynamicStackHandler stackHandler = slotHandler.getStacks();
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            ItemStack stack = stackHandler.getStackInSlot(i);
            if (!(stack.getItem() instanceof SatchelItem)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static SelectedCurio getStorageRemote(Player player) {
        int selectedSlot = player.getInventory().selected;
        ItemStack storageRemoteStack = player.getInventory().getSelected();
        if (!(storageRemoteStack.getItem() instanceof StorageRemoteItem)) {
            selectedSlot = -1;
            storageRemoteStack = CuriosUtil.getStorageRemoteCurio(player);
        }
        if (!(storageRemoteStack.getItem() instanceof StorageRemoteItem)) {
            selectedSlot = CuriosUtil.getFirstStorageRemoteSlot(player);
            ItemStack itemStack = storageRemoteStack = selectedSlot > 0 ? player.getInventory().getItem(selectedSlot) : ItemStack.EMPTY;
        }
        if (storageRemoteStack.getItem() instanceof StorageRemoteItem) {
            return new SelectedCurio(storageRemoteStack, selectedSlot);
        }
        return null;
    }

    public static ItemStack getStorageRemoteCurio(Player player) {
        ICuriosItemHandler curiosHandler = (ICuriosItemHandler)player.getCapability(CuriosCapability.INVENTORY);
        ItemStack hasStorageRemote = ItemStack.EMPTY;
        if (curiosHandler == null) {
            return hasStorageRemote;
        }
        for (ICurioStacksHandler curiosStackshandler : curiosHandler.getCurios().values()) {
            IDynamicStackHandler stackHandler = curiosStackshandler.getStacks();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack = stackHandler.getStackInSlot(i);
                if (!(stack.getItem() instanceof StorageRemoteItem)) continue;
                hasStorageRemote = stack;
                break;
            }
            if (hasStorageRemote.isEmpty()) continue;
            break;
        }
        return hasStorageRemote;
    }

    public static int getFirstBackpackSlot(Player player) {
        for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
            ItemStack stack = player.getInventory().getItem(slot);
            if (!(stack.getItem() instanceof SatchelItem)) continue;
            return slot;
        }
        return -1;
    }

    public static int getFirstStorageRemoteSlot(Player player) {
        for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
            ItemStack stack = player.getInventory().getItem(slot);
            if (!(stack.getItem() instanceof StorageRemoteItem)) continue;
            return slot;
        }
        return -1;
    }

    public static ItemStack getEnderSatchel(Player player) {
        ICuriosItemHandler curiosHandler = (ICuriosItemHandler)player.getCapability(CuriosCapability.INVENTORY);
        if (curiosHandler == null) {
            return ItemStack.EMPTY;
        }
        for (String curio : curiosHandler.getCurios().keySet()) {
            ItemStack stack = CuriosUtil.getEnderSatchelItemFromSlot(curiosHandler, curio);
            if (stack.isEmpty()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    protected static ItemStack getEnderSatchelItemFromSlot(ICuriosItemHandler curiosHandler, String identifier) {
        ICurioStacksHandler slotHandler = curiosHandler.getStacksHandler(identifier).orElse(null);
        if (slotHandler == null) {
            return ItemStack.EMPTY;
        }
        IDynamicStackHandler stackHandler = slotHandler.getStacks();
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            ItemStack stack = stackHandler.getStackInSlot(i);
            if (!(stack.getItem() instanceof EnderSatchelItem)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static int getFirstEnderSatchelSlot(Player player) {
        for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
            ItemStack stack = player.getInventory().getItem(slot);
            if (!(stack.getItem() instanceof EnderSatchelItem)) continue;
            return slot;
        }
        return -1;
    }

    public static class SelectedCurio {
        public ItemStack itemStack;
        public int selectedSlot;

        public SelectedCurio(ItemStack itemStack, int selectedSlot) {
            this.itemStack = itemStack;
            this.selectedSlot = selectedSlot;
        }
    }
}

