/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.common.item.storage.EnderSatchelItem;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.CuriosUtil;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MessageOpenEnderSatchel
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"open_ender_satchel");
    public static final CustomPacketPayload.Type<MessageOpenEnderSatchel> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageOpenEnderSatchel> STREAM_CODEC = CustomPacketPayload.codec(MessageOpenEnderSatchel::encode, MessageOpenEnderSatchel::new);

    public MessageOpenEnderSatchel(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageOpenEnderSatchel() {
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        Item item;
        int selectedSlot = -1;
        ItemStack backpackStack = CuriosUtil.getEnderSatchel((Player)player);
        if (!(backpackStack.getItem() instanceof EnderSatchelItem)) {
            selectedSlot = CuriosUtil.getFirstEnderSatchelSlot((Player)player);
            ItemStack itemStack = backpackStack = selectedSlot > 0 ? player.getInventory().getItem(selectedSlot) : ItemStack.EMPTY;
        }
        if ((item = backpackStack.getItem()) instanceof EnderSatchelItem) {
            EnderSatchelItem enderSatchelItem = (EnderSatchelItem)item;
            String name = player.getName().getString();
            PlayerEnderChestContainer enderChestContainer = player.getEnderChestInventory();
            if (backpackStack.has(OccultismDataComponents.LINKED_PLAYER_UUID)) {
                UUID playerLinkedUUID = ItemNBTUtil.getLinkedPlayerUUID(backpackStack);
                name = ItemNBTUtil.getLikedPlayerName(backpackStack);
                if (playerLinkedUUID != null) {
                    for (ServerLevel eachLvl : Objects.requireNonNull(minecraftServer.getAllLevels())) {
                        Entity entity = eachLvl.getEntity(playerLinkedUUID);
                        if (!(entity instanceof Player)) continue;
                        Player playerLinked = (Player)entity;
                        enderChestContainer = playerLinked.getEnderChestInventory();
                        break;
                    }
                }
            }
            PlayerEnderChestContainer finalEnderChestContainer = enderChestContainer;
            player.openMenu((MenuProvider)new SimpleMenuProvider((p_53124_, p_53125_, p_53126_) -> ChestMenu.threeRows((int)p_53124_, (Inventory)p_53125_, (Container)finalEnderChestContainer), (Component)Component.translatable((String)(((EnderSatchelItem)((Object)OccultismItems.ENDER_SATCHEL.get())).getDescriptionId() + ".chest_menu"), (Object[])new Object[]{name})));
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

