/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.book.summoning_rituals;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePageModel;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CrystallizerFoliotEntry
extends EntryProvider {
    public static final String ENTRY_ID = "summon_crystallizer_t1";

    public CrystallizerFoliotEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)Items.LAPIS_LAZULI);
    }

    protected String entryName() {
        return "Summon Foliot Crystallizer";
    }

    protected String entryDescription() {
        return "Glassy";
    }

    protected void generatePages() {
        this.page("about_crystallizers", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Crystallizer Spirits");
        this.pageText("Crystallizer spirits are summoned to regenerate gem from their dusts and directly multiply\nthe output of breaking gem ores. They will pick up appropriate items and drop the resulting into\nthe world. A magical particle effect and a amethyst sound indicate the crystallizer is at work.\n");
        this.page("automation", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Automation");
        this.pageText("To ease automation, try summoning a {0} to place items from chests in the\n crystallizer''s inventory, and a {1} to collect the processed items.\n", new Object[]{this.entryLink("Transporter Spirit", "summoning_rituals", "summon_transport_items"), this.entryLink("Janitor Spirit", "summoning_rituals", "summon_cleaner")});
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Foliot Crystallizer");
        this.pageText("The foliot crystallizer is the most basic crystallizer spirit.\n\\\n\\\nIt will crystallize in a very low speed.\n");
        this.page("ritual", () -> (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_foliot_crystallizer")));
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

