/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.book.storage_system;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AutomationEntry
extends EntryProvider {
    public static final String ENTRY_ID = "storage_system_automation";

    public AutomationEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)Items.HOPPER);
    }

    protected String entryName() {
        return "Storage Logistics";
    }

    protected String entryDescription() {
        return "Inserting and extracting items from the Storage Actuator";
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Storage Logistics");
        this.pageText("The Storage Actuator behaves much like a big chest or shulker box.\n That means, hoppers and pipes can insert and extract items.\n");
        this.page("performance", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Performance");
        this.pageText("Due to the potentially huge amount of items in the storage system,\n it is good to consider some performance aspects, otherwise your\n system might slow down your game or even a server you are playing on.\n");
        this.page("extraction", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Extracting Items");
        this.pageText("Extracting items can lead to performance issues, especially when pipes with Item Filters\n are used, because then the entire huge storage is searched for these items one by one.\n \\\n \\\n To *massively* improve performance, use Transporter Spirits to extract from the\n Storage Actuator or Stable Wormhole. Even if the Spirit deposits into a chest\n right next to the storage system, and a pipe extracts from that chest, the\n performance is **much** better than if a pipe extracts directly.\n");
        this.page("insertion", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Inserting Items");
        this.pageText("When inserting items, you do not need to do anything, the Storage Actuator will\n maximize performance automatically for you. It is safe to insert high amounts\n of items at high frequencies without negative impact on game performance.\n");
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

