/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe;

import com.klikli_dev.occultism.crafting.recipe.SingleInputRecipe;
import com.klikli_dev.occultism.crafting.recipe.TraderRecipeInput;
import com.klikli_dev.occultism.crafting.recipe.result.WeightedRecipeResult;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SpiritTradeRecipe
extends SingleInputRecipe<TraderRecipeInput> {
    private final String trader;
    protected final WeightedRecipeResult result;
    public static final MapCodec<SpiritTradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(r -> r.input), (App)WeightedRecipeResult.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.STRING.fieldOf("trader_id").forGetter(r -> r.trader)).apply((Applicative)instance, SpiritTradeRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpiritTradeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.input, WeightedRecipeResult.STREAM_CODEC, r -> r.result, (StreamCodec)ByteBufCodecs.STRING_UTF8, r -> r.trader, SpiritTradeRecipe::new);
    public static Serializer SERIALIZER = new Serializer();

    public SpiritTradeRecipe(Ingredient input, WeightedRecipeResult result, String trader) {
        super(input, ItemStack.EMPTY);
        this.result = result;
        this.trader = trader;
    }

    public boolean isSpecial() {
        return true;
    }

    public WeightedRecipeResult getWeightedResult() {
        return this.result;
    }

    @Override
    public boolean matches(TraderRecipeInput inv, @NotNull Level level) {
        return this.input.test(inv.getItem(0)) && inv.trader().equals(this.trader);
    }

    public List<ItemStack> consume(List<ItemStack> input) {
        List<ItemStack> result = input.stream().map(ItemStack::copy).collect(Collectors.toList());
        for (Ingredient ingredient : this.getIngredients()) {
            Iterator<ItemStack> it = result.iterator();
            while (it.hasNext()) {
                ItemStack stack = it.next();
                if (!ingredient.test(stack)) continue;
                stack.shrink(1);
                if (!stack.isEmpty()) continue;
                it.remove();
            }
        }
        return result;
    }

    public boolean isValid(ItemStack ... input) {
        return this.isValid(Arrays.asList(input));
    }

    public boolean isValid(List<ItemStack> input) {
        List cached = input.stream().map(ItemStack::copy).collect(Collectors.toList());
        for (Ingredient ingredient : this.getIngredients()) {
            boolean matched = false;
            Iterator it = cached.iterator();
            while (it.hasNext()) {
                ItemStack stack = (ItemStack)it.next();
                if (!ingredient.test(stack)) continue;
                matched = true;
                stack.shrink(1);
                if (!stack.isEmpty()) continue;
                it.remove();
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.result.getStack();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)OccultismItems.PENTACLE_SUMMON.get());
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)OccultismRecipes.SPIRIT_TRADE_TYPE.get();
    }

    public String getTrader() {
        return this.trader;
    }

    public static class Serializer
    implements RecipeSerializer<SpiritTradeRecipe> {
        @NotNull
        public MapCodec<SpiritTradeRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SpiritTradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

