/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.config;

import net.neoforged.neoforge.common.ModConfigSpec;

public class OccultismServerConfig {
    public final StorageSettings storage;
    public final SpiritJobSettings spiritJobs;
    public final FamiliarSettings familiar;
    public final RitualSettings rituals;
    public final ItemSettings itemSettings;
    public final ModConfigSpec spec;

    public OccultismServerConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.storage = new StorageSettings(builder);
        this.spiritJobs = new SpiritJobSettings(builder);
        this.familiar = new FamiliarSettings(builder);
        this.rituals = new RitualSettings(builder);
        this.itemSettings = new ItemSettings(builder);
        this.spec = builder.build();
    }

    public static class StorageSettings {
        public final ModConfigSpec.IntValue stabilizerTier1AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier1AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue stabilizerTier2AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier2AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue stabilizerTier3AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier3AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue stabilizerTier4AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier4AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue stabilizerTier5AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier5AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue controllerMaxItemTypes;
        public final ModConfigSpec.LongValue controllerMaxTotalItemCount;
        public final ModConfigSpec.IntValue stabilizedControllerStabilizers;
        public final ModConfigSpec.BooleanValue unlinkWormholeOnBreak;

        public StorageSettings(ModConfigSpec.Builder builder) {
            builder.comment("Storage Settings").push("storage");
            this.stabilizerTier1AdditionalMaxItemTypes = builder.comment("The amount of additional slots the storage stabilizer tier 1 provides. 1 Slot holds one item type.").defineInRange("stabilizerTier1AdditionalMaxItemTypes", 64, 0, Integer.MAX_VALUE);
            this.stabilizerTier1AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier1AdditionalMaxTotalItemCount", 512000L, 0L, Integer.MAX_VALUE);
            this.stabilizerTier2AdditionalMaxItemTypes = builder.comment("The amount of slots the storage stabilizer tier 2 provides.").defineInRange("stabilizerTier2AdditionalMaxItemTypes", 128, 0, Integer.MAX_VALUE);
            this.stabilizerTier2AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier2AdditionalMaxTotalItemCount", 1024000L, 0L, Integer.MAX_VALUE);
            this.stabilizerTier3AdditionalMaxItemTypes = builder.comment("The amount of slots the storage stabilizer tier 3 provides.").defineInRange("stabilizerTier3AdditionalMaxItemTypes", 256, 0, Integer.MAX_VALUE);
            this.stabilizerTier3AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier3AdditionalMaxTotalItemCount", 2048000L, 0L, Integer.MAX_VALUE);
            this.stabilizerTier4AdditionalMaxItemTypes = builder.comment("The amount of slots the storage stabilizer tier 4 provides.").defineInRange("stabilizerTier4AdditionalMaxItemTypes", 512, 0, Integer.MAX_VALUE);
            this.stabilizerTier4AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier4AdditionalMaxTotalItemCount", 4096000L, 0L, Long.MAX_VALUE);
            this.stabilizerTier5AdditionalMaxItemTypes = builder.comment("The amount of slots the storage stabilizer tier 5 provides.").defineInRange("stabilizerTier5AdditionalMaxItemTypes", 1024, 0, Integer.MAX_VALUE);
            this.stabilizerTier5AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier5AdditionalMaxTotalItemCount", 0x7D0000L, 0L, Long.MAX_VALUE);
            this.controllerMaxItemTypes = builder.comment("The amount of slots the storage actuator provides.").defineInRange("controllerMaxItemTypes", 128, 0, Integer.MAX_VALUE);
            this.controllerMaxTotalItemCount = builder.comment("The stack size the storage actuator uses.").defineInRange("controllerMaxTotalItemCount", 256000L, 0L, Long.MAX_VALUE);
            this.stabilizedControllerStabilizers = builder.comment("The amount of stabilizers tier 5 in the stabilized storage actuator. (Don't auto change the recipe)").defineInRange("stabilizedControllerStabilizers", 8, 0, Integer.MAX_VALUE);
            this.unlinkWormholeOnBreak = builder.comment("True to unlink the wormhole when break (so it doesn't function as a cheaper Storage Accessor).").define("unlinkWormholeOnBreak", false);
            builder.pop();
        }
    }

    public static class SpiritJobSettings {
        public final TierSpiritSettings crusherFoliot;
        public final TierSpiritSettings crusherDjinni;
        public final TierSpiritSettings crusherAfrit;
        public final TierSpiritSettings crusherMarid;
        public final ModConfigSpec.IntValue crusherResultPickupDelay;
        public final TierSpiritSettings crystallizerFoliot;
        public final TierSpiritSettings crystallizerDjinni;
        public final TierSpiritSettings crystallizerAfrit;
        public final TierSpiritSettings crystallizerMarid;
        public final ModConfigSpec.IntValue crystallizerResultPickupDelay;
        public final SimpleWorkerSpiritSettings smelterFoliot;
        public final SimpleWorkerSpiritSettings smelterDjinni;
        public final SimpleWorkerSpiritSettings smelterAfrit;
        public final SimpleWorkerSpiritSettings smelterMarid;
        public final ModConfigSpec.IntValue smelterResultPickupDelay;
        public final TraderSpiritSettings traderSapling;
        public final TraderSpiritSettings traderOtherstone;
        public final TraderSpiritSettings traderOtherrock;
        public final TraderSpiritSettings traderGem;
        public final ModConfigSpec.IntValue traderResultPickupDelay;
        public final ModConfigSpec.IntValue traderWonderingChance;
        public final ModConfigSpec.IntValue dayTimeToCast;
        public final ModConfigSpec.IntValue nightTimeToCast;
        public final ModConfigSpec.IntValue rainTimeToCast;
        public final ModConfigSpec.IntValue thunderTimeToCast;
        public final ModConfigSpec.IntValue clearWeatherTimeToCast;

        public SpiritJobSettings(ModConfigSpec.Builder builder) {
            builder.comment("Spirit Job Settings").push("spirit_job");
            this.crusherFoliot = new TierSpiritSettings(builder, "Foliot Crusher", "crusher_tier1", 1, 2.0, 1.0, 1);
            this.crusherDjinni = new TierSpiritSettings(builder, "Djinni Crusher", "crusher_tier2", 2, 1.0, 1.5, 1);
            this.crusherAfrit = new TierSpiritSettings(builder, "Afrit Crusher", "crusher_tier3", 3, 0.5, 2.0, 1);
            this.crusherMarid = new TierSpiritSettings(builder, "Marid Crusher", "crusher_tier4", 4, 0.3, 3.0, 1);
            this.crusherResultPickupDelay = builder.comment("The minimum ticks before a crusher can pick up an item it dropped. Default is 3 Seconds = 3 * 20 Ticks.").defineInRange("crusherResultPickupDelay", 60, 0, Integer.MAX_VALUE);
            this.crystallizerFoliot = new TierSpiritSettings(builder, "Foliot Crystallizer", "crystal_tier1", 1, 1.0, 1.0, 1);
            this.crystallizerDjinni = new TierSpiritSettings(builder, "Djinni Crystallizer", "crystal_tier2", 2, 0.5, 1.5, 1);
            this.crystallizerAfrit = new TierSpiritSettings(builder, "Afrit Crystallizer", "crystal_tier3", 3, 0.3, 2.0, 1);
            this.crystallizerMarid = new TierSpiritSettings(builder, "Marid Crystallizer", "crystal_tier4", 4, 0.1, 3.0, 1);
            this.crystallizerResultPickupDelay = builder.comment("The minimum ticks before a crystallizer can pick up an item it dropped. Default is 3 Seconds = 3 * 20 Ticks.").defineInRange("crystallizerResultPickupDelay", 60, 0, Integer.MAX_VALUE);
            this.smelterFoliot = new SimpleWorkerSpiritSettings(builder, "Foliot Smelter", "smelter_tier1", 1.0, 1);
            this.smelterDjinni = new SimpleWorkerSpiritSettings(builder, "Djinni Smelter", "smelter_tier2", 0.5, 1);
            this.smelterAfrit = new SimpleWorkerSpiritSettings(builder, "Afrit Smelter", "smelter_tier3", 0.1, 1);
            this.smelterMarid = new SimpleWorkerSpiritSettings(builder, "Marid Smelter", "smelter_tier4", 0.01, 1);
            this.smelterResultPickupDelay = builder.comment("The minimum ticks before a smelter can pick up an item it dropped. Default is 3 Seconds = 3 * 20 Ticks.").defineInRange("smelterResultPickupDelay", 60, 0, Integer.MAX_VALUE);
            this.traderSapling = new TraderSpiritSettings(builder, "Otherworld Sapling Trader", "trader_sapling", 20, 1);
            this.traderOtherstone = new TraderSpiritSettings(builder, "Otherstone Trader", "trader_otherstone", 10, 4);
            this.traderOtherrock = new TraderSpiritSettings(builder, "Otherrock Trader", "trader_otherrock", 10, 4);
            this.traderGem = new TraderSpiritSettings(builder, "Gambler", "trader_gem", 200, 16);
            this.traderResultPickupDelay = builder.comment("The minimum ticks before a trader can pick up an item it dropped. Default is 3 Seconds = 3 * 20 Ticks.").defineInRange("traderResultPickupDelay", 60, 0, Integer.MAX_VALUE);
            this.traderWonderingChance = builder.comment("The percentage of Wondering Trader replace the Wandering Trader when spawn.").defineInRange("traderWonderingChance", 5, 0, 100);
            this.dayTimeToCast = builder.comment("The time in ticks it takes to cast the day time ritual.").defineInRange("dayTimeToCast", 100, 0, Integer.MAX_VALUE);
            this.nightTimeToCast = builder.comment("The time in ticks it takes to cast the night time ritual.").defineInRange("nightTimeToCast", 100, 0, Integer.MAX_VALUE);
            this.rainTimeToCast = builder.comment("The time in ticks it takes to cast the rain ritual.").defineInRange("rainTimeToCast", 200, 0, Integer.MAX_VALUE);
            this.thunderTimeToCast = builder.comment("The time in ticks it takes to cast the thunder ritual.").defineInRange("thunderTimeToCast", 300, 0, Integer.MAX_VALUE);
            this.clearWeatherTimeToCast = builder.comment("The time in ticks it takes to cast the clear weather ritual.").defineInRange("clearWeatherTimeToCast", 100, 0, Integer.MAX_VALUE);
            builder.pop();
        }

        public static class TierSpiritSettings {
            public final ModConfigSpec.IntValue tier;
            public final ModConfigSpec.DoubleValue timeMultiplier;
            public final ModConfigSpec.DoubleValue outputMultiplier;
            public final ModConfigSpec.IntValue operationCount;

            public TierSpiritSettings(ModConfigSpec.Builder builder, String spirit, String spiritJobName, int tier, double timeMultiplier, double outputMultiplier, int operationCount) {
                builder.comment("Worker Spirit Settings").push(spiritJobName);
                this.tier = builder.comment("The tier of " + spirit).defineInRange("tier", tier, 0, Integer.MAX_VALUE);
                this.timeMultiplier = builder.comment("The multiplier to each recipe's time for " + spirit).defineInRange("timeMultiplier", timeMultiplier, 0.0, 2.147483647E9);
                this.outputMultiplier = builder.comment("The multiplier to each recipe's output count for " + spirit).defineInRange("outputMultiplier", outputMultiplier, 0.0, 2.147483647E9);
                this.operationCount = builder.comment("Max number of recipes that " + spirit + " make per operation.").defineInRange("operationCount", operationCount, 0, 64);
                builder.pop();
            }
        }

        public static class SimpleWorkerSpiritSettings {
            public final ModConfigSpec.DoubleValue timeMultiplier;
            public final ModConfigSpec.IntValue operationCount;

            public SimpleWorkerSpiritSettings(ModConfigSpec.Builder builder, String spirit, String spiritJobName, double timeMultiplier, int operationCount) {
                builder.comment("Worker Spirit Settings").push(spiritJobName);
                this.timeMultiplier = builder.comment("The multiplier to each recipe's time for " + spirit).defineInRange("timeMultiplier", timeMultiplier, 0.0, 2.147483647E9);
                this.operationCount = builder.comment("Max number of recipes that " + spirit + " make per operation.").defineInRange("operationCount", operationCount, 0, 64);
                builder.pop();
            }
        }

        public static class TraderSpiritSettings {
            public final ModConfigSpec.IntValue operationTimer;
            public final ModConfigSpec.IntValue operationCount;

            public TraderSpiritSettings(ModConfigSpec.Builder builder, String spirit, String spiritJobName, int operationTimer, int operationCount) {
                builder.comment("Trader Spirit Settings").push(spiritJobName);
                this.operationTimer = builder.comment("The time to each operation for " + spirit).defineInRange("operationTimer", operationTimer, 0, Integer.MAX_VALUE);
                this.operationCount = builder.comment("Max number of recipes that" + spirit + "make per operation.").defineInRange("operationCount", operationCount, 0, 64);
                builder.pop();
            }
        }
    }

    public static class FamiliarSettings {
        public final ModConfigSpec.IntValue drikwingFamiliarSlowFallingSeconds;
        public final ModConfigSpec.DoubleValue blacksmithFamiliarRepairChance;
        public final ModConfigSpec.IntValue blacksmithFamiliarUpgradeCost;
        public final ModConfigSpec.IntValue blacksmithFamiliarUpgradeCooldown;
        public final ModConfigSpec.IntValue greedySearchRange;
        public final ModConfigSpec.IntValue greedyVerticalSearchRange;

        public FamiliarSettings(ModConfigSpec.Builder builder) {
            builder.comment("Familiar Settings").push("familiar");
            this.drikwingFamiliarSlowFallingSeconds = builder.comment("The duration of slow falling effect given by Drikwing Familiar in seconds.").defineInRange("drikwingFamiliarSlowFallingSeconds", 15, 0, Integer.MAX_VALUE);
            this.blacksmithFamiliarRepairChance = builder.comment("The chance for a blacksmith familiar to repair an item (by 2 durability) whenever stone is picked up. 1.0 = 100%, 0.0 = 0%.").defineInRange("blacksmithFamiliarRepairChance", 0.33, 0.0, Double.MAX_VALUE);
            this.blacksmithFamiliarUpgradeCost = builder.comment("The amount of iron required for a blacksmith familiar to upgrade another familiar.").defineInRange("blacksmithFamiliarUpgradeCost", 18, 0, Integer.MAX_VALUE);
            this.blacksmithFamiliarUpgradeCooldown = builder.comment("The cooldown for a blacksmith familiar to upgrade another familiar.").defineInRange("blacksmithFamiliarUpgradeCooldown", 400, 0, Integer.MAX_VALUE);
            this.greedySearchRange = builder.comment("The horizontal value that the upgraded greedy familiar will seek blocks. (Large distances can cause delays in finding)").defineInRange("greedySearchRange", 32, 0, Integer.MAX_VALUE);
            this.greedyVerticalSearchRange = builder.comment("The vertical value that the upgraded greedy familiar will seek blocks. (Large distances can cause delays in finding)").defineInRange("greedyVerticalSearchRange", 16, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class RitualSettings {
        public final ModConfigSpec.BooleanValue enableClearWeatherRitual;
        public final ModConfigSpec.BooleanValue enableRainWeatherRitual;
        public final ModConfigSpec.BooleanValue enableThunderWeatherRitual;
        public final ModConfigSpec.BooleanValue enableDayTimeRitual;
        public final ModConfigSpec.BooleanValue enableNightTimeRitual;
        public final ModConfigSpec.BooleanValue enableRemainingIngredientCountMatching;
        public final ModConfigSpec.DoubleValue ritualDurationMultiplier;

        public RitualSettings(ModConfigSpec.Builder builder) {
            builder.comment("Ritual Settings").push("rituals");
            this.enableClearWeatherRitual = builder.comment("Enables the ritual to clear rainy weather.").define("enableClearWeatherRitual", true);
            this.enableRainWeatherRitual = builder.comment("Enables the ritual to start rainy weather.").define("enableRainWeatherRitual", true);
            this.enableThunderWeatherRitual = builder.comment("Enables the ritual to start a thunderstorm.").define("enableThunderWeatherRitual", true);
            this.enableDayTimeRitual = builder.comment("Enables the ritual to set time to day.").define("enableDayTimeRitual", true);
            this.enableNightTimeRitual = builder.comment("Enables the ritual to set time to night.").define("enableNightTimeRitual", true);
            this.enableRemainingIngredientCountMatching = builder.comment("If enabled, rituals are interrupted if *more* ingredients are present than needed. This should usually be disabled, but can improve performance if (very very) many rituals are running.").define("enableRemainingIngredientCountMatching", false);
            this.ritualDurationMultiplier = builder.comment("Set a value below 1.0 to speed up rituals. Please ensure to use a preceding 0 for values below 1.0, e.g. '0.05' instead of '.05', otherwise Nightconfig (NeoForge's config sytem) will reset the value to 1.0.").defineInRange("ritualDurationMultiplier", 1.0, 0.05, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class ItemSettings {
        public final ModConfigSpec.BooleanValue anyOreDivinationRod;
        public final ModConfigSpec.BooleanValue minerOutputBeforeBreak;
        public final ModConfigSpec.BooleanValue minerEfficiency;
        public final ModConfigSpec.BooleanValue minerFortune;
        public final ModConfigSpec.BooleanValue minerSilk;
        public final ModConfigSpec.BooleanValue unbreakableChalks;
        public final ModConfigSpec.IntValue maxDistanceRTP;
        public final ModConfigSpec.IntValue maxTryRTP;

        public ItemSettings(ModConfigSpec.Builder builder) {
            builder.comment("Item Settings").push("items");
            this.anyOreDivinationRod = builder.comment("Allow the Divining Rod to attune to any ore").define("anyOreDivinationRod", false);
            this.minerOutputBeforeBreak = builder.comment("Miners head to the output in the Dimensional Mineshaft before it breaks").define("minerOutputBeforeBreak", false);
            this.minerEfficiency = builder.comment("Allow miners enchanted with efficiency mine faster").define("minerEfficiency", true);
            this.minerFortune = builder.comment("Allow miners enchanted with fortune to has a chance of mine extra results each operation").define("minerFortune", true);
            this.minerSilk = builder.comment("Allow miners enchanted with silk touch to has a chance of multiply results each operation").define("minerSilk", true);
            this.unbreakableChalks = builder.comment("Don't damage chalks on use").define("unbreakableChalks", false);
            this.maxDistanceRTP = builder.comment("Maximum distance the Entity Wormhole random teleport (RTP) feature can reach.").defineInRange("maxDistanceRTP", 4096, 0, Integer.MAX_VALUE);
            this.maxTryRTP = builder.comment("Maximum number of attempts to find a safe place for the RTP.").defineInRange("maxTryRTP", 99, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

