/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.spirit;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismSpiritJobs;
import java.util.Objects;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DjinniEntity
extends SpiritEntity
implements GeoEntity {
    private static final EntityDataAccessor<Integer> SIZE_STATE = SynchedEntityData.defineId(DjinniEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected EntityDimensions manageMachineDimensions = EntityDimensions.scalable((float)0.5f, (float)0.8f);
    AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public DjinniEntity(EntityType<? extends SpiritEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SpiritEntity.createAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ARMOR, 4.0).add(Attributes.ARMOR_TOUGHNESS, 5.0).add(Attributes.FOLLOW_RANGE, 50.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SIZE_STATE, (Object)0);
    }

    public int getSizeState() {
        return (Integer)this.entityData.get(SIZE_STATE);
    }

    public void setSizeState(int sizeState) {
        this.entityData.set(SIZE_STATE, (Object)sizeState);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (SIZE_STATE.equals(pKey)) {
            this.refreshDimensions();
        }
        if (JOB_ID.equals(pKey) && this.getSizeState() != 1 && (Objects.equals(this.getJobID(), OccultismSpiritJobs.MANAGE_MACHINE.getId().toString()) || Objects.equals(this.getJobID(), OccultismSpiritJobs.TRADE_GAMBLER.getId().toString()))) {
            this.setSizeState(1);
        }
        super.onSyncedDataUpdated(pKey);
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose pPose) {
        if (this.getSizeState() == 1) {
            return this.manageMachineDimensions;
        }
        return super.getDefaultDimensions(pPose);
    }

    public int getCurrentSwingDuration() {
        return 11;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController mainController = new AnimationController((GeoAnimatable)this, "mainController", 0, this::animPredicate);
        controllers.add(mainController);
    }

    private <T extends GeoAnimatable> PlayState animPredicate(AnimationState<T> tAnimationState) {
        if (this.swinging) {
            return tAnimationState.setAndContinue(RawAnimation.begin().thenLoop("attack"));
        }
        return tAnimationState.setAndContinue(tAnimationState.isMoving() ? RawAnimation.begin().thenPlay("walk") : RawAnimation.begin().thenPlay("idle"));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public boolean isFood(ItemStack pStack) {
        return false;
    }
}

