/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.klikli_dev.occultism.common.container.spirit.SpiritTransporterContainer;
import com.klikli_dev.occultism.common.entity.ai.goal.DepositItemsGoal;
import com.klikli_dev.occultism.common.entity.ai.goal.ExtractItemsGoal;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TransportItemsJob
extends SpiritJob
implements MenuProvider {
    protected DepositItemsGoal depositItemsGoal;
    protected ExtractItemsGoal extractItemsGoal;
    protected OpenDoorGoal openDoorGoal;

    public TransportItemsJob(SpiritEntity entity) {
        super(entity);
    }

    public Component getDisplayName() {
        return this.entity.getDisplayName();
    }

    @Override
    public void onInit() {
        this.entity.getNavigation().getNodeEvaluator().setCanPassDoors(true);
        ((GroundPathNavigation)this.entity.getNavigation()).setCanOpenDoors(true);
        this.depositItemsGoal = new DepositItemsGoal(this.entity);
        this.entity.goalSelector.addGoal(3, (Goal)this.depositItemsGoal);
        this.extractItemsGoal = new ExtractItemsGoal(this.entity);
        this.entity.goalSelector.addGoal(4, (Goal)this.extractItemsGoal);
        this.openDoorGoal = new OpenDoorGoal((Mob)this.entity, true);
        this.entity.goalSelector.addGoal(5, (Goal)this.openDoorGoal);
    }

    @Override
    public void cleanup() {
        this.entity.getNavigation().getNodeEvaluator().setCanPassDoors(false);
        ((GroundPathNavigation)this.entity.getNavigation()).setCanOpenDoors(false);
        this.entity.goalSelector.removeGoal((Goal)this.depositItemsGoal);
        this.entity.goalSelector.removeGoal((Goal)this.extractItemsGoal);
        this.entity.goalSelector.removeGoal((Goal)this.openDoorGoal);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new SpiritTransporterContainer(id, playerInventory, this.entity);
    }
}

