/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.entity.familiar.CthulhuFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.GoatFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.GreedyFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.ShubNiggurathSpawnEntity;
import com.klikli_dev.occultism.registry.OccultismEntities;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class ShubNiggurathFamiliarEntity
extends FamiliarEntity {
    private static final int MAX_SPAWN_TIMER = 200;
    private int spawnTimer = 200;

    public ShubNiggurathFamiliarEntity(EntityType<? extends ShubNiggurathFamiliarEntity> type, Level level) {
        super(type, level);
    }

    public ShubNiggurathFamiliarEntity(Level level, GoatFamiliarEntity goat) {
        this((EntityType<? extends ShubNiggurathFamiliarEntity>)OccultismEntities.SHUB_NIGGURATH_FAMILIAR.get(), level);
        this.setRing(goat.hasRing());
        this.setBeard(goat.hasBeard());
        this.setFamiliarOwner(goat.getFamiliarOwner());
        this.setPos(goat.getX(), goat.getY(), goat.getZ());
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.goalSelector.addGoal(3, new GreedyFamiliarEntity.RideFamiliarGoal<CthulhuFamiliarEntity>(this, OccultismEntities.CTHULHU_FAMILIAR.get()));
        this.goalSelector.addGoal(6, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(9, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.rotateTowardsFriend();
            this.createSpawn((LivingEntity)this, new Vector3d(this.getRandomX(2.0), this.getRandomY(), this.getRandomZ(2.0)));
        }
    }

    protected float tickHeadTurn(float p_110146_1_, float distance) {
        if ((double)distance > 0.1) {
            this.yBodyRot = this.yRotO;
            this.yHeadRot = Mth.rotateIfNecessary((float)this.yHeadRot, (float)this.yBodyRot, (float)this.getMaxHeadYRot());
        }
        return distance;
    }

    public CthulhuFamiliarEntity getCthulhuFriend() {
        if (this.getVehicle() instanceof CthulhuFamiliarEntity) {
            return (CthulhuFamiliarEntity)this.getVehicle();
        }
        return null;
    }

    private void createSpawn(LivingEntity creator, Vector3d pos) {
        if (this.spawnTimer-- < 0) {
            this.spawnTimer = 200;
            ShubNiggurathSpawnEntity spawn = new ShubNiggurathSpawnEntity(creator.level(), creator);
            spawn.setPos(pos.x, pos.y, pos.z);
            creator.level().addFreshEntity((Entity)spawn);
        }
    }

    private void rotateTowardsFriend() {
        CthulhuFamiliarEntity friend = this.getCthulhuFriend();
        if (friend != null) {
            Vec3 direction = this.position().vectorTo(friend.position());
            float rot = (float)Math.toDegrees(Mth.atan2((double)direction.z, (double)direction.x)) - 50.0f;
            this.yRotO = this.yRotO;
            this.yBodyRot = this.yRotO = rot;
            this.yBodyRotO = this.yRotO;
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.getVehicle() != null && this.immuneWhileHoldingHand(pSource)) {
            return false;
        }
        if (super.hurt(pSource, pAmount)) {
            if (pSource.getEntity() != null) {
                GoatFamiliarEntity.ringBell(this);
            }
            return true;
        }
        return false;
    }

    private boolean immuneWhileHoldingHand(DamageSource s) {
        return s.is(DamageTypeTags.BYPASSES_ARMOR);
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean hasRing() {
        return this.hasVariant(0);
    }

    private void setRing(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasBeard() {
        return this.hasVariant(1);
    }

    private void setBeard(boolean b) {
        this.setVariant(1, b);
    }
}

