/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.registry.OccultismItems;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class OtherworldBirdEntity
extends Parrot
implements IFamiliar {
    private static final EntityDataAccessor<Boolean> BLACKSMITH_UPGRADE = SynchedEntityData.defineId(OtherworldBirdEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final float MAX_BOOST_DISTANCE = 8.0f;
    public SitWhenOrderedToGoal sitGoal;

    public OtherworldBirdEntity(EntityType<? extends Parrot> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Parrot.createAttributes();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BLACKSMITH_UPGRADE, (Object)false);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setBlacksmithUpgrade(compound.getBoolean("hasBlacksmithUpgrade"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("hasBlacksmithUpgrade", this.hasBlacksmithUpgrade());
    }

    protected void registerGoals() {
        this.sitGoal = new SitWhenOrderedToGoal((TamableAnimal)this);
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)this.sitGoal);
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 5.0f, 1.0f));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void aiStep() {
        LivingEntity owner;
        if (!this.level().isClientSide && this.level().getGameTime() % 10L == 0L && this.isTame() && (owner = this.getOwner()) != null && this.distanceTo((Entity)owner) < 8.0f) {
            for (MobEffectInstance effect : this.getFamiliarEffects()) {
                owner.addEffect(effect);
            }
        }
        super.aiStep();
    }

    public void setOwnerUUID(@Nullable UUID ownerId) {
        super.setOwnerUUID(ownerId);
    }

    @Override
    public LivingEntity getFamiliarOwner() {
        return this.getOwner();
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        this.setOwnerUUID(owner.getUUID());
    }

    @Override
    public Entity getFamiliarEntity() {
        return this;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        effects.add(new MobEffectInstance(MobEffects.JUMP, 60, 5, false, false));
        if (this.hasBlacksmithUpgrade()) {
            effects.add(new MobEffectInstance(OccultismEffects.DOUBLE_JUMP, 120, 9, false, false));
        } else {
            effects.add(new MobEffectInstance(OccultismEffects.DOUBLE_JUMP, 120, 4, false, false));
            effects.add(new MobEffectInstance(MobEffects.SLOW_FALLING, 20 * (Integer)Occultism.SERVER_CONFIG.familiar.drikwingFamiliarSlowFallingSeconds.get(), 0, false, false));
        }
        return effects;
    }

    public boolean hasBlacksmithUpgrade() {
        return (Boolean)this.entityData.get(BLACKSMITH_UPGRADE);
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    private void setBlacksmithUpgrade(boolean b) {
        this.entityData.set(BLACKSMITH_UPGRADE, (Object)b);
    }

    @Override
    public void blacksmithUpgrade() {
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.displayClientMessage((Component)Component.translatable((String)String.format("message.%s.familiar.upgraded", "occultism"), (Object[])new Object[]{this.getName()}), true);
        }
        this.setCustomName((Component)Component.empty().append(this.getName()).append(" \u26e4"));
        this.setBlacksmithUpgrade(true);
    }

    public InteractionResult mobInteract(Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (stack.getItem() == OccultismItems.FAMILIAR_RING.get()) {
            return stack.interactLivingEntity(playerIn, (LivingEntity)this, hand);
        }
        return super.mobInteract(playerIn, hand);
    }

    protected void dropFromLootTable(DamageSource pDamageSource, boolean pAttackedRecently) {
        super.dropFromLootTable(pDamageSource, pAttackedRecently);
        LivingEntity owner = this.getFamiliarOwner();
        ItemStack shard = new ItemStack((ItemLike)OccultismItems.SOUL_SHARD_ITEM.get());
        float health = this.getHealth();
        this.setHealth(this.getMaxHealth());
        this.resetFallDistance();
        this.removeAllEffects();
        CompoundTag entityData = new CompoundTag();
        String id = this.getEncodeId();
        if (id != null) {
            entityData.putString("id", id);
        }
        entityData = this.saveWithoutId(entityData);
        shard.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityData));
        this.setHealth(health);
        if (owner instanceof Player) {
            Player player = (Player)owner;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)shard);
        } else {
            ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), shard);
            entityitem.setPickUpDelay(5);
            entityitem.setDeltaMovement(entityitem.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            this.level().addFreshEntity((Entity)entityitem);
        }
    }
}

