/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.DragonFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEntities;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public class GreedyFamiliarEntity
extends FamiliarEntity {
    private static final EntityDataAccessor<Optional<BlockPos>> TARGET_BLOCK = SynchedEntityData.defineId(GreedyFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private float earRotZ;
    private float earRotZ0;
    private float earRotX;
    private float earRotX0;
    private float peekRot;
    private float peekRot0;
    private float monsterRot;
    private float monsterRot0;
    private int monsterAnimTimer = this.getRandom().nextInt(100);

    public GreedyFamiliarEntity(EntityType<? extends GreedyFamiliarEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FamiliarEntity.FamiliarPanicGoal(this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.goalSelector.addGoal(2, (Goal)new FindBlockGoal(this));
        this.goalSelector.addGoal(3, new RideFamiliarGoal<DragonFamiliarEntity>(this, OccultismEntities.DRAGON_FAMILIAR.get()));
        this.goalSelector.addGoal(4, (Goal)new FindItemGoal(this));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TARGET_BLOCK, Optional.empty());
    }

    public Optional<BlockPos> getTargetBlock() {
        return (Optional)this.entityData.get(TARGET_BLOCK);
    }

    private void setTargetBlock(Optional<BlockPos> pos) {
        this.entityData.set(TARGET_BLOCK, pos);
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public void curioTick(LivingEntity wearer) {
        if (!(wearer instanceof Player)) {
            return;
        }
        if (this.isEffectEnabled(wearer)) {
            for (ItemEntity e : wearer.level().getEntitiesOfClass(ItemEntity.class, wearer.getBoundingBox().inflate(5.0), Entity::isAlive)) {
                ItemStack stack = e.getItem();
                boolean isStackDemagnetized = false;
                boolean isEntityDemagnetized = e.getPersistentData().getBoolean("PreventRemoteMovement");
                if (isStackDemagnetized || isEntityDemagnetized) continue;
                e.playerTouch((Player)wearer);
            }
        }
    }

    public void tick() {
        super.tick();
        this.earRotX0 = this.earRotX;
        this.earRotZ0 = this.earRotZ;
        if (this.level().isClientSide) {
            Optional<BlockPos> targetBlock = this.getTargetBlock();
            if (targetBlock.isPresent()) {
                Vec3 p = Vec3.atCenterOf((Vec3i)((Vec3i)targetBlock.get()));
                float endZRot = -0.5f;
                if (Math.abs(p.y - this.getEyeY()) > 1.0) {
                    endZRot = p.y > this.getEyeY() ? 0.0f : -2.0f;
                }
                this.earRotZ = Mth.lerp((float)0.1f, (float)this.earRotZ, (float)endZRot);
                Vec3 look = this.getViewVector(1.0f);
                Vec3 toTarget = p.vectorTo(this.position()).normalize();
                toTarget = new Vec3(toTarget.x, 0.0, toTarget.z);
                float endXRot = toTarget.dot(look) < 0.0 ? 1.0f : -1.0f;
                this.earRotX = Mth.lerp((float)0.1f, (float)this.earRotX, (float)endXRot);
            } else {
                this.earRotX = Mth.lerp((float)0.1f, (float)this.earRotX, (float)0.0f);
                this.earRotZ = Mth.lerp((float)0.1f, (float)this.earRotZ, (float)-0.5f);
            }
            ++this.monsterAnimTimer;
            this.peekRot0 = this.peekRot;
            this.monsterRot0 = this.monsterRot;
            if (this.monsterAnimTimer % 300 < 200) {
                float peekTimer = this.monsterAnimTimer % 300 % 200;
                if (peekTimer > 30.0f && peekTimer < 50.0f) {
                    this.monsterRot = Mth.lerp((float)0.3f, (float)this.monsterRot, (float)this.toRad(37.0f));
                } else if (peekTimer > 50.0f && peekTimer < 70.0f) {
                    this.monsterRot = Mth.lerp((float)0.3f, (float)this.monsterRot, (float)this.toRad(-37.0f));
                } else if (peekTimer > 70.0f) {
                    this.monsterRot = Mth.lerp((float)0.3f, (float)this.monsterRot, (float)0.0f);
                }
                this.peekRot = peekTimer < 100.0f ? Mth.lerp((float)0.1f, (float)this.peekRot, (float)this.toRad(46.0f)) : Mth.lerp((float)0.1f, (float)this.peekRot, (float)0.0f);
            } else {
                this.peekRot = 0.0f;
                this.monsterRot = 0.0f;
            }
        }
    }

    private float toRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public float getLidRot(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.peekRot0, (float)this.peekRot);
    }

    public float getMonsterRot(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.monsterRot0, (float)this.monsterRot);
    }

    public float getEarRotZ(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.earRotZ0, (float)this.earRotZ);
    }

    public float getEarRotX(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.earRotX0, (float)this.earRotX);
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    @Override
    protected InteractionResult mobInteract(Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (this.hasBlacksmithUpgrade() && !this.getOffhandItem().isEmpty()) {
            ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)this.getOffhandItem());
            this.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.hasBlacksmithUpgrade() && stack.getItem() instanceof BlockItem) {
            this.setItemInHand(InteractionHand.OFF_HAND, new ItemStack((ItemLike)stack.getItem()));
            stack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(playerIn, hand);
    }

    private static class FindBlockGoal
    extends MoveToBlockGoal {
        GreedyFamiliarEntity greedy;

        public FindBlockGoal(GreedyFamiliarEntity greedy) {
            super((PathfinderMob)greedy, 1.0, Occultism.SERVER_CONFIG.familiar.greedySearchRange.getAsInt(), Occultism.SERVER_CONFIG.familiar.greedyVerticalSearchRange.getAsInt());
            this.greedy = greedy;
        }

        public boolean canUse() {
            return super.canUse() && !this.mob.getOffhandItem().isEmpty();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && !this.mob.getOffhandItem().isEmpty();
        }

        protected boolean isValidTarget(LevelReader pLevel, BlockPos pPos) {
            ItemStack offhand = this.mob.getOffhandItem();
            return pLevel.getBlockState(pPos).getBlock() == Block.byItem((Item)offhand.getItem());
        }

        public void start() {
            super.start();
            this.greedy.setTargetBlock(Optional.of(this.blockPos));
        }

        public void stop() {
            super.stop();
            this.greedy.setTargetBlock(Optional.empty());
        }

        protected BlockPos getMoveToTarget() {
            return this.blockPos;
        }
    }

    public static class RideFamiliarGoal<T extends FamiliarEntity>
    extends Goal {
        private final FamiliarEntity rider;
        private final EntityType<T> type;
        private FamiliarEntity mount;

        public RideFamiliarGoal(FamiliarEntity rider, EntityType<T> type) {
            this.rider = rider;
            this.type = type;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            if (this.rider.getVehicle() != null && this.rider.getVehicle().getType() == this.type) {
                return true;
            }
            FamiliarEntity mount = this.findMount();
            if (mount != null) {
                this.mount = mount;
                this.rider.getNavigation().moveTo((Entity)mount, 1.0);
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.rider.getVehicle() != null && this.rider.getVehicle().getType() == this.type || this.rider.isPathFinding() && this.mount != null;
        }

        public void stop() {
            this.rider.stopRiding();
            this.mount = null;
        }

        public void tick() {
            if (this.mount != null && this.rider.distanceToSqr((Entity)this.mount) < 5.0 && !this.mount.hasPassenger((Entity)this.rider)) {
                this.rider.startRiding((Entity)this.mount);
                this.mount.getNavigation().stop();
                if (this.rider.getType() == OccultismEntities.SHUB_NIGGURATH_FAMILIAR.get() && this.type == OccultismEntities.CTHULHU_FAMILIAR.get()) {
                    ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(this.rider.getFamiliarOwner(), FamiliarTrigger.Type.SHUB_CTHULHU_FRIENDS);
                }
            }
        }

        private FamiliarEntity findMount() {
            LivingEntity owner = this.rider.getOwner();
            if (owner == null) {
                return null;
            }
            List mounts = this.rider.level().getEntities(this.type, this.rider.getBoundingBox().inflate(5.0), e -> e.getFamiliarOwner() == owner && !e.isVehicle() && !e.isSitting());
            if (mounts.isEmpty()) {
                return null;
            }
            return (FamiliarEntity)mounts.get(0);
        }
    }

    public static class FindItemGoal
    extends Goal {
        private static final double RANGE = 12.0;
        private final FamiliarEntity entity;

        public FindItemGoal(FamiliarEntity entity) {
            this.entity = entity;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return this.getNearbyItem() != null && this.entity.getFamiliarOwner() instanceof Player;
        }

        public void start() {
            ItemEntity item = this.getNearbyItem();
            if (item != null) {
                this.entity.getNavigation().moveTo((Entity)item, 1.2);
            }
        }

        public void tick() {
            ItemEntity item = this.getNearbyItem();
            if (item != null) {
                this.entity.getNavigation().moveTo((Entity)item, 1.2);
                LivingEntity owner = this.entity.getFamiliarOwner();
                if (item.distanceToSqr((Entity)this.entity) < 4.0 && owner instanceof Player) {
                    Player player = (Player)owner;
                    item.playerTouch(player);
                    ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(owner, FamiliarTrigger.Type.GREEDY_ITEM);
                }
            }
        }

        private ItemEntity getNearbyItem() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            if (!(owner instanceof Player)) {
                return null;
            }
            Player player = (Player)owner;
            PlayerMainInvWrapper inv = new PlayerMainInvWrapper(player.getInventory());
            for (ItemEntity item : this.entity.level().getEntitiesOfClass(ItemEntity.class, this.entity.getBoundingBox().inflate(12.0), e -> e.isAlive())) {
                ItemStack stack = item.getItem();
                boolean isStackDemagnetized = false;
                boolean isEntityDemagnetized = item.getPersistentData().getBoolean("PreventRemoteMovement");
                if (isStackDemagnetized || isEntityDemagnetized || ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)true).getCount() == stack.getCount()) continue;
                return item;
            }
            return null;
        }
    }
}

