/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.behaviour;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.util.StorageUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class ReplantSaplingBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    public static final double REPLANT_RANGE_SQUARE = Math.pow(3.5, 2.0);
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(OccultismMemoryTypes.LAST_FELLED_TREE.get(), (Object)MemoryStatus.VALUE_PRESENT)});

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        BlockPos treePos = (BlockPos)((List)BrainUtils.getMemory(entity, OccultismMemoryTypes.LAST_FELLED_TREE.get())).getFirst();
        double dist = entity.distanceToSqr(Vec3.atCenterOf((Vec3i)treePos));
        return StorageUtil.getFirstMatchingSlot((IItemHandler)((SpiritEntity)entity).inventory, (TagKey<Item>)ItemTags.SAPLINGS) != -1 && dist <= REPLANT_RANGE_SQUARE;
    }

    protected void start(E entity) {
        List lastFelledTreeList = (List)BrainUtils.getMemory(entity, OccultismMemoryTypes.LAST_FELLED_TREE.get());
        BlockPos lastFelledTree = (BlockPos)lastFelledTreeList.getFirst();
        if (entity.level().isEmptyBlock(lastFelledTree)) {
            ItemStackHandler handler;
            ItemStack sapling;
            Item item;
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(lastFelledTree));
            if (entity.level().getBlockState(lastFelledTree.below()).is(BlockTags.DIRT) && (item = (sapling = (handler = ((SpiritEntity)entity).inventory).getStackInSlot(StorageUtil.getFirstMatchingSlot((IItemHandler)handler, (TagKey<Item>)ItemTags.SAPLINGS))).getItem()) instanceof BlockItem) {
                BlockItem saplingBlockItem = (BlockItem)item;
                entity.level().setBlockAndUpdate(lastFelledTree, saplingBlockItem.getBlock().defaultBlockState());
                sapling.shrink(1);
            }
        }
        lastFelledTreeList.removeFirst();
        if (lastFelledTreeList.isEmpty()) {
            BrainUtils.clearMemory(entity, OccultismMemoryTypes.LAST_FELLED_TREE.get());
        } else {
            BrainUtils.setMemory(entity, OccultismMemoryTypes.LAST_FELLED_TREE.get(), (Object)lastFelledTreeList);
        }
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

