/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.behaviour;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.util.Math3DUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.NotNull;

public class PickupItemBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    public static final double PICKUP_XZ_RANGE_SQUARE = 3.5;
    public static final double PICKUP_Y_RANGE = 16.0;
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.DEPOSIT_POSITION.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.DEPOSIT_FACING.get(), (Object)MemoryStatus.VALUE_PRESENT)});

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull E entity) {
        ItemEntity jobItem = (ItemEntity)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM);
        return Math3DUtil.withinAxisDistances(entity.position(), jobItem.position(), 3.5, 16.0, 3.5) && ItemHandlerHelper.insertItemStacked((IItemHandler)((SpiritEntity)entity).inventory, (ItemStack)jobItem.getItem(), (boolean)true).getCount() < jobItem.getItem().getCount();
    }

    protected void start(E entity) {
        ItemEntity jobItem = (ItemEntity)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM);
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)jobItem, false));
        ItemStack duplicate = jobItem.getItem().copy();
        ItemStackHandler handler = ((SpiritEntity)entity).inventory;
        if (ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)true).getCount() < duplicate.getCount()) {
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)false);
            jobItem.getItem().setCount(remaining.getCount());
        }
        for (ItemEntity e : entity.level().getEntitiesOfClass(ItemEntity.class, jobItem.getBoundingBox().inflate(3.0), Entity::isAlive)) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)e.getItem().copy(), (boolean)true).getCount() > 64) continue;
            ItemStack remains = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)e.getItem().copy(), (boolean)false);
            e.getItem().setCount(remains.getCount());
        }
        BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM);
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

