/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import com.klikli_dev.occultism.client.gui.IesniumAnvilMenu;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IesniumAnvilBlock
extends FallingBlock {
    public static final MapCodec<IesniumAnvilBlock> CODEC = IesniumAnvilBlock.simpleCodec(IesniumAnvilBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape BASE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape X_LEG1 = Block.box((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0);
    private static final VoxelShape X_LEG2 = Block.box((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape X_TOP = Block.box((double)0.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape Z_LEG1 = Block.box((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)13.0);
    private static final VoxelShape Z_LEG2 = Block.box((double)6.0, (double)5.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0);
    private static final VoxelShape Z_TOP = Block.box((double)3.0, (double)10.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape X_AXIS_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{X_LEG1, X_LEG2, X_TOP});
    private static final VoxelShape Z_AXIS_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Z_LEG1, Z_LEG2, Z_TOP});
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.repair");
    private static final float FALL_DAMAGE_PER_DISTANCE = 2.0f;
    private static final int FALL_DAMAGE_MAX = 4096;

    public MapCodec<IesniumAnvilBlock> codec() {
        return CODEC;
    }

    public IesniumAnvilBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getClockWise());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        player.awardStat(Stats.INTERACT_WITH_ANVIL);
        return InteractionResult.CONSUME;
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((p_48785_, p_48786_, p_48787_) -> new IesniumAnvilMenu(p_48785_, p_48786_, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), CONTAINER_TITLE);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return direction.getAxis() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    protected void falling(FallingBlockEntity fallingEntity) {
        fallingEntity.setHurtsEntities(2.0f, 4096);
        fallingEntity.disableDrop();
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        if (level.getBlockState(pos).canBeReplaced()) {
            level.destroyBlock(pos, true);
            level.setBlockAndUpdate(pos, fallingBlock.getBlockState());
            if (!fallingBlock.isSilent()) {
                level.levelEvent(1031, pos, 0);
            }
        } else {
            if (level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                ItemEntity item = new ItemEntity(level, fallingBlock.getX(), fallingBlock.getY(), fallingBlock.getZ(), fallingBlock.getBlockState().getBlock().asItem().getDefaultInstance());
                level.addFreshEntity((Entity)item);
            }
            if (!fallingBlock.isSilent()) {
                level.levelEvent(1029, pos, 0);
            }
        }
    }

    public DamageSource getFallDamageSource(Entity entity) {
        return entity.damageSources().anvil(entity);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public int getDustColor(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getMapColor((BlockGetter)reader, (BlockPos)pos).col;
    }
}

