/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.client.renderer;

import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.BaseEndermanEntityRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.BaseEndermanModel;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.CustomCarriedBlockLayer;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.CustomEnderEyesLayer;
import tech.alexnijjar.endermanoverhaul.common.entities.ReplacedEnderman;

public class ReplacedEndermanRenderer
extends GeoReplacedEntityRenderer<EnderMan, ReplacedEnderman> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"endermanoverhaul", (String)"default/default_enderman");
    public static final ResourceLocation GLOW = ResourceLocation.fromNamespaceAndPath((String)"endermanoverhaul", (String)"textures/entity/default/default_enderman_glow.png");

    public ReplacedEndermanRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new BaseEndermanModel(ResourceLocation.fromNamespaceAndPath((String)"endermanoverhaul", (String)"default_enderman"), true, TEXTURE, BaseEndermanEntityRenderer.ANIMATION), (GeoAnimatable)new ReplacedEnderman());
        this.addRenderLayer(new CustomEnderEyesLayer(this, GLOW));
        this.addRenderLayer(new CustomCarriedBlockLayer(this, renderManager.getBlockRenderDispatcher(), () -> (EnderMan)this.currentEntity, false));
    }

    @NotNull
    public Vec3 getRenderOffset(EnderMan entity, float partialTicks) {
        if (entity.isCreepy()) {
            Level level = entity.level();
            return new Vec3(level.random.nextGaussian() * 0.02, 0.0, level.random.nextGaussian() * 0.02);
        }
        return super.getRenderOffset((Entity)entity, partialTicks);
    }
}

