/*
 * Decompiled with CFR 0.152.
 */
package fuzs.moblassos.world.item;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Unit;
import fuzs.moblassos.MobLassos;
import fuzs.moblassos.config.ServerConfig;
import fuzs.moblassos.init.ModRegistry;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;

public enum LassoType implements StringRepresentable
{
    GOLDEN("golden", entity -> entity instanceof Animal || entity instanceof AmbientCreature, () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).goldenLassoTime),
    AQUA("aqua", entity -> entity instanceof WaterAnimal, () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).aquaLassoTime),
    DIAMOND("diamond", entity -> entity instanceof Animal || entity instanceof AmbientCreature || entity instanceof WaterAnimal, () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).diamondLassoTime),
    EMERALD("emerald", entity -> entity instanceof AbstractVillager, () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).emeraldLassoTime){

        @Override
        protected Either<MutableComponent, Unit> isValidMob(Mob mob) {
            Either<MutableComponent, Unit> result = super.isValidMob(mob);
            if (!((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).villagersRequireContract) {
                return result;
            }
            if (result.left().isEmpty() && !ModRegistry.VILLAGER_CONTRACT_ATTACHMENT_TYPE.has((Object)mob)) {
                return Either.left((Object)Component.translatable((String)this.getFailureTranslationKey(), (Object[])new Object[]{mob.getDisplayName()}));
            }
            return result;
        }
    }
    ,
    HOSTILE("hostile", entity -> entity instanceof Enemy, () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).hostileLassoTime, true){

        @Override
        protected Either<MutableComponent, Unit> isValidMob(Mob mob) {
            Either<MutableComponent, Unit> result = super.isValidMob(mob);
            if (result.left().isEmpty()) {
                double hostileMobHealth = ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).hostileMobHealth;
                if ((double)(mob.getHealth() / mob.getMaxHealth()) >= hostileMobHealth) {
                    MutableComponent component = Component.translatable((String)this.getFailureTranslationKey(), (Object[])new Object[]{mob.getDisplayName(), String.format("%.0f", hostileMobHealth * (double)mob.getMaxHealth()), String.format("%.0f", Float.valueOf(mob.getHealth()))});
                    return Either.left((Object)component);
                }
            }
            return result;
        }
    }
    ,
    CREATIVE("creative", entity -> true, () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).creativeLassoTime, true);

    private final String name;
    private final Predicate<Mob> filter;
    private final IntSupplier holdingTime;

    private LassoType(String name, Predicate<Mob> filter, IntSupplier holdingTime) {
        this(name, filter, holdingTime, false);
    }

    private LassoType(String name, Predicate<Mob> filter, IntSupplier holdingTime, boolean allowHostile) {
        this.name = name;
        this.filter = mob -> filter.test((Mob)mob) && (allowHostile || !(mob instanceof Enemy));
        this.holdingTime = holdingTime;
    }

    public String getSerializedName() {
        return this.name;
    }

    public boolean hasMaxHoldingTime() {
        return this.holdingTime.getAsInt() != -1;
    }

    public int getMaxHoldingTime() {
        return this.holdingTime.getAsInt() * 20;
    }

    public TagKey<EntityType<?>> getEntityTypeTagKey() {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)MobLassos.id("forbidden_in_" + this.name + "_lasso"));
    }

    public boolean canPlayerPickUp(Player player, Mob mob) {
        return this.isValidMob(mob).ifLeft(component -> player.displayClientMessage((Component)component.withStyle(ChatFormatting.RED), true)).right().isPresent();
    }

    protected Either<MutableComponent, Unit> isValidMob(Mob mob) {
        if (!CommonAbstractions.INSTANCE.isBossMob(mob.getType()) && !mob.getType().is(this.getEntityTypeTagKey()) && this.filter.test(mob)) {
            return Either.right((Object)Unit.INSTANCE);
        }
        return Either.left((Object)Component.translatable((String)GOLDEN.getFailureTranslationKey(), (Object[])new Object[]{mob.getDisplayName()}));
    }

    public String getFailureTranslationKey() {
        return "item.moblassos.failure." + this.name;
    }
}

