/*
 * Decompiled with CFR 0.152.
 */
package net.athebyne.exclusions_lib.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import java.util.function.Predicate;
import net.athebyne.exclusions_lib.ExclusionsLib;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.NotNull;

public class OverlapsStructureBlockPredicate
implements BlockPredicate {
    public static final MapCodec<OverlapsStructureBlockPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Vec3i.offsetCodec((int)16).optionalFieldOf("offset", (Object)BlockPos.ZERO).forGetter(predicate -> predicate.offset), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE).optionalFieldOf("structures", (Object)HolderSet.empty()).forGetter(OverlapsStructureBlockPredicate::structure), (App)Codec.intRange((int)0, (int)32).optionalFieldOf("range", (Object)0).forGetter(predicate -> predicate.range)).apply((Applicative)instance, OverlapsStructureBlockPredicate::new));
    private final Vec3i offset;
    private final int range;
    private final HolderSet<Structure> structures;

    public OverlapsStructureBlockPredicate(Vec3i offset, HolderSet<Structure> structures, int range) {
        this.structures = structures;
        this.offset = offset;
        this.range = range;
    }

    public boolean test(WorldGenLevel worldGenLevel, BlockPos blockPos) {
        ServerLevel world = worldGenLevel.getLevel();
        StructureManager accessor = world.structureManager();
        BlockPos blockPosOffset = blockPos.offset(this.offset);
        Predicate<StructureStart> predicate = this.makePredicate(blockPosOffset);
        for (Map.Entry struct : accessor.getAllStructuresAt(blockPosOffset).entrySet()) {
            if (this.structures.size() != 0 && !this.structures.contains(worldGenLevel.registryAccess().registryOrThrow(Registries.STRUCTURE).wrapAsHolder((Object)((Structure)struct.getKey())))) continue;
            LongIterator longIterator = ((LongSet)struct.getValue()).iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                SectionPos sectionPos = SectionPos.of((ChunkPos)new ChunkPos(pos), (int)world.getMinSection());
                StructureStart start = accessor.getStartForStructure(sectionPos, (Structure)struct.getKey(), (StructureAccess)world.getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_STARTS));
                if (start == null || !start.isValid() || !predicate.test(start)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private Predicate<StructureStart> makePredicate(BlockPos blockPosOffset) {
        BoundingBox exclusionZone = new BoundingBox(blockPosOffset.getX() - this.range, blockPosOffset.getY() - this.range, blockPosOffset.getZ() - this.range, blockPosOffset.getX() + this.range, blockPosOffset.getY() + this.range, blockPosOffset.getZ() + this.range);
        return start -> {
            for (StructurePiece piece : start.getPieces()) {
                if (!piece.getBoundingBox().intersects(exclusionZone)) continue;
                return true;
            }
            return false;
        };
    }

    public HolderSet<Structure> structure() {
        return this.structures;
    }

    public BlockPredicateType<?> type() {
        return (BlockPredicateType)ExclusionsLib.OVERLAPS_STRUCTURE.get();
    }
}

