/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.jrdemiurge.enigmaticlegacy.EnigmaticLegacy;
import net.jrdemiurge.enigmaticlegacy.entities.custom.PermanentItemEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class SoulArchive {
    private static final Type SOUL_RECORDS_TYPE = new TypeToken<List<SoulData>>(){}.getType();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static SoulArchive instance;
    private final File saveFile;
    private final Multimap<ResourceKey<Level>, SoulData> data = HashMultimap.create();

    public SoulArchive(File saveFolder) {
        Preconditions.checkArgument((saveFolder.exists() && saveFolder.isDirectory() ? 1 : 0) != 0, (Object)("File " + String.valueOf(saveFolder) + " does not exist or is not a folder!"));
        this.saveFile = new File(saveFolder, "soul_archive.json");
    }

    public Optional<Tuple<UUID, BlockPos>> findNearest(Player player, BlockPos pos) {
        SoulData data = this.data.get((Object)player.level().dimension()).stream().filter(record -> record.type == 0).filter(record -> Objects.equals(record.ownerID, player.getUUID())).reduce((r1, r2) -> pos.distSqr((Vec3i)r1.pos) > pos.distSqr((Vec3i)r2.pos) ? r2 : r1).orElse(null);
        return data != null ? Optional.of(new Tuple((Object)data.id, (Object)data.pos)) : Optional.empty();
    }

    public Optional<Tuple<UUID, BlockPos>> findNearest(Level level, BlockPos pos) {
        SoulData data = this.data.get((Object)level.dimension()).stream().filter(record -> record.type == 0).reduce((r1, r2) -> pos.distSqr((Vec3i)r1.pos) > pos.distSqr((Vec3i)r2.pos) ? r2 : r1).orElse(null);
        return data != null ? Optional.of(new Tuple((Object)data.id, (Object)data.pos)) : Optional.empty();
    }

    public void save() {
        try (FileOutputStream out = FileUtils.openOutputStream((File)this.saveFile, (boolean)false);){
            IOUtils.write((byte[])this.saveToBytes(), (OutputStream)out);
        }
        catch (Exception ex) {
            EnigmaticLegacy.LOGGER.error("FAILED TO SAVE FILE: " + String.valueOf(this.saveFile));
            throw new RuntimeException(ex);
        }
    }

    public void load() {
        try {
            if (!this.saveFile.exists() || !this.saveFile.isFile()) {
                return;
            }
            try (FileInputStream in = FileUtils.openInputStream((File)this.saveFile);){
                byte[] bytes = ((InputStream)in).readAllBytes();
                this.loadFromBytes(bytes);
            }
        }
        catch (Exception ex) {
            EnigmaticLegacy.LOGGER.error("FAILED TO LOAD FILE: " + String.valueOf(this.saveFile));
            throw new RuntimeException(ex);
        }
    }

    private byte[] saveToBytes() {
        String text = new GsonBuilder().setPrettyPrinting().create().toJson(new ArrayList(this.data.values()));
        return text.getBytes(UTF8);
    }

    private void loadFromBytes(byte[] bytes) {
        this.data.clear();
        String text = new String(bytes, UTF8);
        List list = (List)new Gson().fromJson(text, SOUL_RECORDS_TYPE);
        list.forEach(record -> {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)record.dimension);
            this.data.put((Object)key, record);
        });
    }

    private void synchronize() {
        ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers().forEach(player -> {});
    }

    public void addItem(PermanentItemEntity item) {
        SoulData record = new SoulData(item.level().dimension().location(), item.getUUID(), item.getOwnerId(), item.blockPosition(), item.containsSoul() ? 0 : 1);
        if (this.data.put((Object)item.level().dimension(), (Object)record)) {
            this.save();
            this.synchronize();
        }
    }

    public void removeItem(UUID id) {
        if (this.data.values().removeIf(record -> record.id.equals(id))) {
            this.save();
            this.synchronize();
        }
    }

    public void removeItem(PermanentItemEntity item) {
        if (this.data.values().removeIf(record -> record.isEqual(item))) {
            this.save();
            this.synchronize();
        }
    }

    public static SoulArchive getInstance() {
        return instance;
    }

    public static void initialize(MinecraftServer server) {
        instance = new SoulArchive(server.getWorldPath(LevelResource.ROOT).toFile());
        instance.load();
    }

    private static class SoulData {
        private ResourceLocation dimension;
        private UUID id;
        private UUID ownerID;
        private BlockPos pos;
        private int type;

        SoulData(ResourceLocation dimension, UUID id, UUID ownerID, BlockPos pos, int type) {
            this.dimension = dimension;
            this.id = id;
            this.ownerID = ownerID;
            this.pos = pos;
            this.type = type;
        }

        public int hashCode() {
            return Objects.hash(this.dimension, this.id, this.ownerID, this.pos, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SoulData other = (SoulData)obj;
            return Objects.equals(this.dimension, other.dimension) && Objects.equals(this.id, other.id) && Objects.equals(this.ownerID, other.ownerID) && Objects.equals(this.pos, other.pos) && this.type == other.type;
        }

        public String toString() {
            return "SoulData [dimension=" + String.valueOf(this.dimension) + ", id=" + String.valueOf(this.id) + ", ownerID=" + String.valueOf(this.ownerID) + ", pos=" + String.valueOf(this.pos) + ", type=" + this.type + "]";
        }

        boolean isEqual(PermanentItemEntity item) {
            return Objects.equals(this.id, item.getUUID()) && Objects.equals(this.ownerID, item.getOwnerId());
        }
    }
}

