/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.jrdemiurge.enigmaticlegacy.Config;
import net.jrdemiurge.enigmaticlegacy.item.ModItems;
import net.jrdemiurge.enigmaticlegacy.item.custom.SoulCrystal;
import net.jrdemiurge.enigmaticlegacy.stat.ModStats;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableBoolean;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class ModUtils {
    private static long lastRequestMs = 0L;
    private static final long COOLDOWN_MS = 5000L;

    public static boolean hasCurio(LivingEntity livingEntity, Item curio) {
        return CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(handler -> !handler.findCurios(curio).isEmpty()).orElse(false);
    }

    public static boolean isTheCursedOne(Player player) {
        return ModUtils.hasCurio((LivingEntity)player, (Item)ModItems.CURSED_RING.get());
    }

    public static boolean isTheWorthyOne(Player player) {
        if (ModUtils.isTheCursedOne(player)) {
            return ModUtils.getSufferingFraction(player) >= Config.SUPER_CURSED_TIME.getAsDouble();
        }
        return false;
    }

    public static double getSufferingFraction(Player player) {
        int withoutTicks;
        ServerStatsCounter stats = null;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            stats = serverPlayer.getStats();
        } else if (player.level().isClientSide) {
            stats = ModUtils.getClientStats();
        }
        if (stats == null) {
            return 0.0;
        }
        int withTicks = stats.getValue(Stats.CUSTOM.get((Object)ModStats.TIME_WITH_CURSED_RING.get()));
        long total = (long)withTicks + (long)(withoutTicks = stats.getValue(Stats.CUSTOM.get((Object)ModStats.TIME_WITHOUT_CURSED_RING.get())));
        if (total == 0L) {
            return 0.0;
        }
        return (double)withTicks / (double)total;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static StatsCounter getClientStats() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        return player != null ? player.getStats() : null;
    }

    public static String getSufferingTime(@Nullable Player player) {
        Object text = "";
        double ringPercent = 100.0 * ModUtils.getSufferingFraction(player);
        text = (ringPercent = ModUtils.roundToPlaces(ringPercent, 1)) - Math.floor(ringPercent) == 0.0 ? (String)text + (int)ringPercent + "%" : (String)text + ringPercent + "%";
        return text;
    }

    public static double roundToPlaces(double value, int places) {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void indicateCursedOnesOnly(List<Component> list) {
        ChatFormatting format = Minecraft.getInstance().player != null ? (ModUtils.isTheCursedOne((Player)Minecraft.getInstance().player) ? ChatFormatting.GOLD : ChatFormatting.DARK_RED) : ChatFormatting.DARK_RED;
        list.add((Component)Component.translatable((String)"tooltip.enigmaticlegacy.cursedOnesOnly1").withStyle(format));
        list.add((Component)Component.translatable((String)"tooltip.enigmaticlegacy.cursedOnesOnly2").withStyle(format));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void indicateWorthyOnesOnly(List<Component> list) {
        ChatFormatting format = ChatFormatting.DARK_RED;
        LocalPlayer player = Minecraft.getInstance().player;
        ModUtils.requestIfStale();
        if (player != null) {
            format = ModUtils.isTheWorthyOne((Player)Minecraft.getInstance().player) ? ChatFormatting.GOLD : ChatFormatting.DARK_RED;
        }
        double requiredCurse = ModUtils.roundToPlaces(100.0 * Config.SUPER_CURSED_TIME.getAsDouble(), 1);
        list.add((Component)Component.translatable((String)"tooltip.enigmaticlegacy.worthyOnesOnly1"));
        list.add((Component)Component.translatable((String)"tooltip.enigmaticlegacy.worthyOnesOnly2", (Object[])new Object[]{Component.literal((String)(requiredCurse + "%")).withStyle(ChatFormatting.GOLD)}).withStyle(format));
        list.add((Component)Component.translatable((String)"tooltip.enigmaticlegacy.worthyOnesOnly3"));
        list.add((Component)Component.translatable((String)"tooltip.enigmaticlegacy.void"));
        list.add((Component)Component.translatable((String)"tooltip.enigmaticlegacy.worthyOnesOnly4").withStyle(format).append((Component)Component.literal((String)(" " + ModUtils.getSufferingTime((Player)player))).withStyle(ChatFormatting.LIGHT_PURPLE)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void requestIfStale() {
        long now = System.currentTimeMillis();
        if (now - lastRequestMs < 5000L) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientPacketListener conn = mc.getConnection();
        if (conn == null) {
            return;
        }
        conn.send((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
        lastRequestMs = now;
    }

    public static void addLocalizedString(List<Component> list, String str) {
        list.add((Component)Component.translatable((String)str));
    }

    public static void addLocalizedString(List<Component> list, String str, @Nullable ChatFormatting format, Object ... values) {
        Component[] stringValues = new Component[values.length];
        int counter = 0;
        for (Object value : values) {
            MutableComponent comp = value instanceof MutableComponent ? (MutableComponent)value : Component.literal((String)value.toString());
            if (format != null) {
                comp.withStyle(format);
            }
            stringValues[counter] = comp;
            ++counter;
        }
        list.add((Component)Component.translatable((String)str, (Object[])stringValues));
    }

    public static boolean tryForceEquip(LivingEntity entity, ItemStack curio) {
        if (!(curio.getItem() instanceof ICurioItem)) {
            throw new IllegalArgumentException("I fear for now this only works with ICurioItem");
        }
        MutableBoolean equipped = new MutableBoolean(false);
        ICurioItem item = (ICurioItem)curio.getItem();
        CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(handler -> {
            if (!entity.level().isClientSide) {
                Map curios = handler.getCurios();
                block0: for (Map.Entry entry : curios.entrySet()) {
                    IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
                    for (int i = 0; i < stackHandler.getSlots(); ++i) {
                        ItemStack present = stackHandler.getStackInSlot(i);
                        Set tags = CuriosApi.getCuriosHelper().getCurioTags(curio.getItem());
                        String id = (String)entry.getKey();
                        SlotContext context = new SlotContext(id, entity, i, false, ((ICurioStacksHandler)entry.getValue()).isVisible());
                        if (!present.isEmpty() || !tags.contains(id) && !tags.contains("curio") || !item.canEquip(context, curio)) continue;
                        stackHandler.setStackInSlot(i, curio);
                        equipped.setTrue();
                        break block0;
                    }
                }
            }
        });
        return equipped.booleanValue();
    }

    public static void setPersistentInteger(Player player, String tag, int value) {
        ModUtils.setPersistentTag(player, tag, (Tag)IntTag.valueOf((int)value));
    }

    public static void setPersistentTag(Player player, String tag, Tag value) {
        CompoundTag persistent;
        CompoundTag data = player.getPersistentData();
        if (!data.contains("PlayerPersisted")) {
            persistent = new CompoundTag();
            data.put("PlayerPersisted", (Tag)persistent);
        } else {
            persistent = data.getCompound("PlayerPersisted");
        }
        persistent.put(tag, value);
    }

    public static int getPersistentInteger(Player player, String tag, int expectedValue) {
        Tag theTag = ModUtils.getPersistentTag(player, tag, (Tag)IntTag.valueOf((int)expectedValue));
        return theTag instanceof IntTag ? ((IntTag)theTag).getAsInt() : expectedValue;
    }

    public static Tag getPersistentTag(Player player, String tag, Tag expectedValue) {
        CompoundTag persistent;
        CompoundTag data = player.getPersistentData();
        if (!data.contains("PlayerPersisted")) {
            persistent = new CompoundTag();
            data.put("PlayerPersisted", (Tag)persistent);
        } else {
            persistent = data.getCompound("PlayerPersisted");
        }
        if (persistent.contains(tag)) {
            return persistent.get(tag);
        }
        return expectedValue;
    }

    public static boolean isAbsolute(DamageSource source) {
        return source.is(DamageTypeTags.BYPASSES_INVULNERABILITY);
    }

    public static boolean canDropSoulCrystal(Player player, boolean hadRing) {
        if (ModUtils.isAffectedBySoulLoss(player, hadRing)) {
            int maxCrystalLoss = Config.MAX_SOUL_CRYSTAL_LOSS.getAsInt();
            return SoulCrystal.getLostCrystals(player) < maxCrystalLoss;
        }
        return false;
    }

    public static boolean isAffectedBySoulLoss(Player player, boolean hadRing) {
        int dropMode = Config.SOUL_CRYSTAL_MODE.getAsInt();
        boolean keepInventory = player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
        if (dropMode == 0) {
            return hadRing;
        }
        if (dropMode == 1) {
            return hadRing || keepInventory;
        }
        return dropMode == 2;
    }
}

