/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.util;

import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public final class ItemNBTHelper {
    public static boolean detectNBT(ItemStack stack) {
        return stack.has(DataComponents.CUSTOM_DATA);
    }

    public static void initNBT(ItemStack stack) {
        if (!ItemNBTHelper.detectNBT(stack)) {
            ItemNBTHelper.injectNBT(stack, new CompoundTag());
        }
    }

    public static void injectNBT(ItemStack stack, CompoundTag nbt) {
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
    }

    public static CompoundTag getNBT(ItemStack stack) {
        ItemNBTHelper.initNBT(stack);
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return new CompoundTag();
        }
        return data.getUnsafe();
    }

    public static void setBoolean(ItemStack stack, String tag, boolean b) {
        ItemNBTHelper.getNBT(stack).putBoolean(tag, b);
    }

    public static void setByte(ItemStack stack, String tag, byte b) {
        ItemNBTHelper.getNBT(stack).putByte(tag, b);
    }

    public static void setShort(ItemStack stack, String tag, short s) {
        ItemNBTHelper.getNBT(stack).putShort(tag, s);
    }

    public static void setInt(ItemStack stack, String tag, int i) {
        ItemNBTHelper.getNBT(stack).putInt(tag, i);
    }

    public static void setLong(ItemStack stack, String tag, long l) {
        ItemNBTHelper.getNBT(stack).putLong(tag, l);
    }

    public static void setFloat(ItemStack stack, String tag, float f) {
        ItemNBTHelper.getNBT(stack).putFloat(tag, f);
    }

    public static void setDouble(ItemStack stack, String tag, double d) {
        ItemNBTHelper.getNBT(stack).putDouble(tag, d);
    }

    public static void setString(ItemStack stack, String tag, String s) {
        ItemNBTHelper.getNBT(stack).putString(tag, s);
    }

    public static void setUUID(ItemStack stack, String tag, UUID id) {
        ItemNBTHelper.getNBT(stack).putUUID(tag, id);
    }

    public static boolean verifyExistance(ItemStack stack, String tag) {
        return stack != null && ItemNBTHelper.getNBT(stack).contains(tag);
    }

    public static boolean getBoolean(ItemStack stack, String tag, boolean defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).getBoolean(tag) : defaultExpected;
    }

    public static boolean containsUUID(ItemStack stack, String tag) {
        return stack != null && ItemNBTHelper.getNBT(stack).hasUUID(tag);
    }

    public static UUID getUUID(ItemStack stack, String tag, UUID defaultExpected) {
        return ItemNBTHelper.containsUUID(stack, tag) ? ItemNBTHelper.getNBT(stack).getUUID(tag) : defaultExpected;
    }

    public static byte getByte(ItemStack stack, String tag, byte defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).getByte(tag) : defaultExpected;
    }

    public static short getShort(ItemStack stack, String tag, short defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).getShort(tag) : defaultExpected;
    }

    public static int getInt(ItemStack stack, String tag, int defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).getInt(tag) : defaultExpected;
    }

    public static long getLong(ItemStack stack, String tag, long defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).getLong(tag) : defaultExpected;
    }

    public static float getFloat(ItemStack stack, String tag, float defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).getFloat(tag) : defaultExpected;
    }

    public static double getDouble(ItemStack stack, String tag, double defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).getDouble(tag) : defaultExpected;
    }

    public static CompoundTag getCompound(ItemStack stack, String tag, boolean nullifyOnFail) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).getCompound(tag) : (nullifyOnFail ? null : new CompoundTag());
    }

    public static String getString(ItemStack stack, String tag, String defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).getString(tag) : defaultExpected;
    }
}

