/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.network;

import io.netty.buffer.ByteBuf;
import net.jrdemiurge.enigmaticlegacy.util.ModUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EnderRingKeyPayload(boolean pressed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EnderRingKeyPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"enigmaticlegacy", (String)"ender_ring_key"));
    public static final StreamCodec<ByteBuf, EnderRingKeyPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, EnderRingKeyPayload::pressed, EnderRingKeyPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleOnServer(EnderRingKeyPayload msg, IPayloadContext ctx) {
        if (!msg.pressed()) {
            return;
        }
        Player player = ctx.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!ModUtils.isTheCursedOne((Player)player2)) {
            return;
        }
        SimpleMenuProvider provider = new SimpleMenuProvider((id, inv, p) -> new ChestMenu(MenuType.GENERIC_9x3, id, inv, (Container)p.getEnderChestInventory(), 3){

            public void removed(Player p2) {
                super.removed(p2);
                if (!p2.level().isClientSide) {
                    p2.level().playSound(null, p2.blockPosition(), SoundEvents.ENDER_CHEST_CLOSE, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                }
            }
        }, (Component)Component.translatable((String)"container.enderchest"));
        player2.openMenu((MenuProvider)provider);
        player2.level().playSound(null, player2.blockPosition(), SoundEvents.ENDER_CHEST_OPEN, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
    }
}

