/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.item.custom;

import java.util.Collection;
import javax.annotation.Nullable;
import net.jrdemiurge.enigmaticlegacy.item.custom.IPermanentCrystal;
import net.jrdemiurge.enigmaticlegacy.item.custom.SoulCrystal;
import net.jrdemiurge.enigmaticlegacy.util.ExperienceHelper;
import net.jrdemiurge.enigmaticlegacy.util.ItemNBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class StorageCrystal
extends Item
implements IPermanentCrystal {
    public StorageCrystal(Item.Properties properties) {
        super(properties);
    }

    public ItemStack storeDropsOnCrystal(Collection<ItemEntity> drops, Player player, @Nullable ItemStack embeddedSoulCrystal) {
        ItemStack crystal = new ItemStack((ItemLike)this);
        CompoundTag crystalNBT = ItemNBTHelper.getNBT(crystal);
        int counter = 0;
        RegistryAccess registries = player.level().registryAccess();
        for (ItemEntity drop : drops) {
            ItemStack dropStack = drop.getItem();
            CompoundTag nbt = (CompoundTag)dropStack.save((HolderLookup.Provider)registries, (Tag)new CompoundTag());
            crystalNBT.put("storedStack" + counter, (Tag)nbt);
            ++counter;
        }
        if (embeddedSoulCrystal != null) {
            CompoundTag embeddedTag = (CompoundTag)embeddedSoulCrystal.save((HolderLookup.Provider)registries, (Tag)new CompoundTag());
            crystalNBT.put("embeddedSoul", (Tag)embeddedTag);
        }
        ItemNBTHelper.setInt(crystal, "storedStacks", counter);
        int exp = ExperienceHelper.getPlayerXP(player);
        ExperienceHelper.drainPlayerXP(player, exp);
        ItemNBTHelper.setInt(crystal, "storedXP", exp);
        ItemNBTHelper.setBoolean(crystal, "isStored", true);
        return crystal;
    }

    public static ItemStack retrieveDropsFromCrystal(ItemStack crystal, Player player, ItemStack retrieveSoul) {
        CompoundTag crystalNBT = ItemNBTHelper.getNBT(crystal);
        int counter = crystalNBT.getInt("storedStacks") - 1;
        int exp = crystalNBT.getInt("storedXP");
        RegistryAccess registries = player.level().registryAccess();
        for (int c = counter; c >= 0; --c) {
            CompoundTag tag = crystalNBT.getCompound("storedStack" + c);
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag);
            if (!stack.isEmpty() && !player.getInventory().add(stack)) {
                ItemEntity drop = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), stack);
                player.level().addFreshEntity((Entity)drop);
            }
            crystalNBT.remove("storedStack" + c);
        }
        ExperienceHelper.addPlayerXP(player, exp);
        if (retrieveSoul != null) {
            SoulCrystal.retrieveSoulFromCrystal(player, retrieveSoul);
        } else {
            player.level().playSound(null, BlockPos.containing((Position)player.position()), SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        ItemNBTHelper.setBoolean(crystal, "isStored", false);
        ItemNBTHelper.setInt(crystal, "storedStacks", 0);
        ItemNBTHelper.setInt(crystal, "storedXP", 0);
        return crystal;
    }
}

