/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.item.custom;

import java.util.List;
import net.jrdemiurge.enigmaticlegacy.item.custom.IPermanentCrystal;
import net.jrdemiurge.enigmaticlegacy.util.ModUtils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SoulCrystal
extends Item
implements IPermanentCrystal {
    public SoulCrystal(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.soulCrystal1");
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.soulCrystal2");
        } else {
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    public ItemStack createCrystalFrom(Player player) {
        int lostFragments = SoulCrystal.getLostCrystals(player);
        SoulCrystal.setLostCrystals(player, lostFragments + 1);
        return new ItemStack((ItemLike)this);
    }

    public static boolean retrieveSoulFromCrystal(Player player, ItemStack stack) {
        int lostFragments = SoulCrystal.getLostCrystals(player);
        if (lostFragments > 0) {
            SoulCrystal.setLostCrystals(player, lostFragments - 1);
            if (!player.level().isClientSide) {
                player.level().playSound(null, BlockPos.containing((Position)player.position()), SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public static void setLostCrystals(Player player, int lost) {
        ModUtils.setPersistentInteger(player, "enigmaticlegacy.lostsoulfragments", lost);
        SoulCrystal.updatePlayerSoulMap(player);
    }

    public static int getLostCrystals(Player player) {
        return ModUtils.getPersistentInteger(player, "enigmaticlegacy.lostsoulfragments", 0);
    }

    public static void updatePlayerSoulMap(Player player) {
        if (player.level().isClientSide) {
            return;
        }
        AttributeInstance inst = player.getAttribute(Attributes.MAX_HEALTH);
        if (inst == null) {
            return;
        }
        int lostFragments = ModUtils.getPersistentInteger(player, "enigmaticlegacy.lostsoulfragments", 0);
        AttributeModifier attrOld = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"enigmaticlegacy", (String)"soul_crystal.max_health"), (double)(-0.1f * (float)(lostFragments + 1)), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        inst.removeModifier(attrOld);
        if (lostFragments > 0) {
            AttributeModifier attr = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"enigmaticlegacy", (String)"soul_crystal.max_health"), (double)(-0.1f * (float)lostFragments), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            inst.addTransientModifier(attr);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        if (SoulCrystal.retrieveSoulFromCrystal(player, stack)) {
            stack.consume(1, (LivingEntity)player);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }
}

