/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.item.custom;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jrdemiurge.enigmaticlegacy.Config;
import net.jrdemiurge.enigmaticlegacy.mixin.EnderManAccessor;
import net.jrdemiurge.enigmaticlegacy.util.ModUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CursedRing
extends Item
implements ICurioItem {
    public CursedRing(Item.Properties properties) {
        super(properties);
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        ArrayListMultimap attributeMap = ArrayListMultimap.create();
        attributeMap.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"enigmaticlegacy", (String)"cursed_ring.armor"), (double)(-((Integer)Config.ARMOR_DEBUFF.get()).intValue()) / 100.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        attributeMap.put((Object)Attributes.ARMOR_TOUGHNESS, (Object)new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"enigmaticlegacy", (String)"cursed_ring.armor_toughness"), (double)(-((Integer)Config.ARMOR_DEBUFF.get()).intValue()) / 100.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        attributeMap.put((Object)Attributes.BLOCK_INTERACTION_RANGE, (Object)new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"enigmaticlegacy", (String)"cursed_ring.block_interaction_range"), Config.BLOCK_INTERACTION_RANGE_BONUS.getAsDouble(), AttributeModifier.Operation.ADD_VALUE));
        return attributeMap;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }

    public boolean canUnequip(SlotContext context, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = context.entity();
        return livingEntity instanceof Player && (player = (Player)livingEntity).isCreative();
    }

    public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
        return false;
    }

    @Nonnull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, boolean recentlyHit, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    @Nonnull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity;
        if (context.entity().level().isClientSide || !((livingEntity = context.entity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.isCreative() || player.isSpectator()) {
            return;
        }
        RandomSource random = player.getRandom();
        List genericMobs = player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(Config.NEUTRAL_ANGER_RANGE.getAsDouble()));
        List endermen = player.level().getEntitiesOfClass(EnderMan.class, player.getBoundingBox().inflate(Config.ENDERMAN_RANDOMPORT_RANGE.getAsDouble()));
        for (EnderMan enderman : endermen) {
            if (!(random.nextDouble() <= 0.002 * Config.ENDERMAN_RANDOMPORT_FREQUENCY.getAsDouble()) || !((EnderManAccessor)enderman).callTeleportTowards((Entity)player) || !player.hasLineOfSight((Entity)enderman)) continue;
            enderman.setTarget((LivingEntity)player);
        }
        for (LivingEntity checkedEntity : genericMobs) {
            IronGolem golem;
            TamableAnimal tamable;
            double visibility = player.getVisibilityPercent((Entity)checkedEntity);
            double angerDistance = Math.max(Config.NEUTRAL_ANGER_RANGE.getAsDouble() * visibility, Config.NEUTRAL_X_RAY_RANGE.getAsDouble());
            if (checkedEntity.distanceToSqr(player.getX(), player.getY(), player.getZ()) > angerDistance * angerDistance || !(checkedEntity instanceof NeutralMob)) continue;
            NeutralMob neutral = (NeutralMob)checkedEntity;
            ResourceLocation mobId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)checkedEntity.getType());
            List whitelist = (List)Config.NEUTRAL_ANGER_WHITELIST.get();
            if (!whitelist.contains(mobId.toString()) || neutral instanceof TamableAnimal && (tamable = (TamableAnimal)neutral).isTame() || neutral instanceof IronGolem && (golem = (IronGolem)neutral).isPlayerCreated() || neutral.getTarget() != null && neutral.getTarget().isAlive() || !player.hasLineOfSight((Entity)checkedEntity) && !((double)player.distanceTo((Entity)checkedEntity) <= Config.NEUTRAL_X_RAY_RANGE.getAsDouble())) continue;
            neutral.setTarget((LivingEntity)player);
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.isClientSide || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (Config.AUTO_EQUIP.isTrue() && !player.isCreative() && !player.isSpectator() && !ModUtils.isTheCursedOne(player) && ModUtils.tryForceEquip((LivingEntity)player, stack)) {
            player.getInventory().setItem(slotId, ItemStack.EMPTY);
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public double getAngerRange() {
        return Config.NEUTRAL_ANGER_RANGE.getAsDouble();
    }

    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack curio) {
        return defaultInstance.getFortuneLevel(slotContext, lootContext) + Config.FORTUNE_BONUS.getAsInt();
    }

    public int getLootingLevel(SlotContext slotContext, @Nullable LootContext lootContext, ItemStack stack) {
        return defaultInstance.getLootingLevel(slotContext, lootContext) + Config.LOOTING_BONUS.getAsInt();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.void");
        if (Screen.hasShiftDown()) {
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing3");
            if ((double)Config.PAIN_MODIFIER.getAsInt() / 100.0 == 2.0) {
                ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing4");
            } else {
                ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing4_alt", ChatFormatting.GOLD, Config.PAIN_MODIFIER.getAsInt() + "%");
            }
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing5");
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing6", ChatFormatting.GOLD, String.valueOf(Config.ARMOR_DEBUFF.get()) + "%");
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing7", ChatFormatting.GOLD, String.valueOf(Config.MONSTER_DAMAGE_DEBUFF.get()) + "%");
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing8");
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing9");
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing10");
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.void");
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing11");
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing12", ChatFormatting.GOLD, Config.LOOTING_BONUS.get());
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing13", ChatFormatting.GOLD, Config.FORTUNE_BONUS.get());
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing14", ChatFormatting.GOLD, String.valueOf(Config.EXPERIENCE_BONUS.get()) + "%");
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing15", ChatFormatting.GOLD, Config.ENCHANTING_BONUS.get());
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing16", ChatFormatting.GOLD, Config.BLOCK_INTERACTION_RANGE_BONUS.get());
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing17");
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRing18");
        } else {
            if (Config.ENABLE_LORE.isTrue()) {
                ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRingLore1");
                ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRingLore2");
                ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRingLore3");
                ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRingLore4");
                ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRingLore5");
                ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRingLore6");
                ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.cursedRingLore7");
                ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.void");
            }
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.eternallyBound1");
            if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.isCreative()) {
                ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.eternallyBound2_creative");
            } else {
                ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.eternallyBound2");
            }
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.void");
            ModUtils.addLocalizedString(tooltipComponents, "tooltip.enigmaticlegacy.holdShift");
        }
    }
}

