/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import top.theillusivec4.curios.client.gui.CuriosScreen;

@OnlyIn(value=Dist.CLIENT)
public abstract class PlayerInventoryButton
extends AbstractWidget {
    protected final AbstractContainerScreen<?> parentGui;
    protected final ResourceLocation texture;
    protected final int u;
    protected final int v;
    protected final int texW;
    protected final int texH;
    protected final int yDiffTex;
    protected boolean isRecipeBookVisible = false;
    private final OnPress onPress;

    public PlayerInventoryButton(AbstractContainerScreen<?> gui, int x, int y, int w, int h, int u, int v, int yDiffTex, ResourceLocation texture, OnPress onPress) {
        super(x, y, w, h, CommonComponents.EMPTY);
        this.parentGui = gui;
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.yDiffTex = yDiffTex;
        this.texW = 256;
        this.texH = 256;
        this.onPress = onPress;
        this.active = true;
        this.visible = true;
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.active && this.visible && this.isMouseOver(mouseX, mouseY)) {
            this.onPress.onPress(this);
        }
    }

    protected void renderWidget(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.active = true;
        if (this.parentGui instanceof InventoryScreen || this.parentGui instanceof CuriosScreen) {
            boolean lastVisible = this.isRecipeBookVisible;
            AbstractContainerScreen<?> abstractContainerScreen = this.parentGui;
            if (abstractContainerScreen instanceof InventoryScreen) {
                InventoryScreen inv = (InventoryScreen)abstractContainerScreen;
                this.isRecipeBookVisible = inv.getRecipeBookComponent().isVisible();
            } else {
                abstractContainerScreen = this.parentGui;
                if (abstractContainerScreen instanceof CuriosScreen) {
                    CuriosScreen curios = (CuriosScreen)abstractContainerScreen;
                    this.isRecipeBookVisible = curios.getRecipeBookComponent().isVisible();
                }
            }
            if (lastVisible != this.isRecipeBookVisible) {
                Tuple<Integer, Integer> offsets = this.getOffsets(false);
                this.setPosition(this.parentGui.getGuiLeft() + (Integer)offsets.getA(), this.parentGui.getGuiTop() + (Integer)offsets.getB());
            }
        } else {
            CreativeModeInventoryScreen creative;
            AbstractContainerScreen<?> abstractContainerScreen = this.parentGui;
            if (abstractContainerScreen instanceof CreativeModeInventoryScreen && !(creative = (CreativeModeInventoryScreen)abstractContainerScreen).isInventoryOpen()) {
                this.active = false;
                return;
            }
        }
        if (!this.beforeRender(g, mouseX, mouseY, partialTick)) {
            return;
        }
        int v0 = this.v + (this.isHoveredOrFocused() ? this.yDiffTex : 0);
        g.blit(this.texture, this.getX(), this.getY(), (float)this.u, (float)v0, this.getWidth(), this.getHeight(), this.texW, this.texH);
    }

    protected void updateWidgetNarration(NarrationElementOutput out) {
    }

    protected abstract boolean beforeRender(GuiGraphics var1, int var2, int var3, float var4);

    public abstract Tuple<Integer, Integer> getOffsets(boolean var1);

    public static interface OnPress {
        public void onPress(PlayerInventoryButton var1);
    }
}

