/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.event;

import net.jrdemiurge.enigmaticlegacy.gui.EnderChestInventoryButton;
import net.jrdemiurge.enigmaticlegacy.network.EnderRingKeyPayload;
import net.jrdemiurge.enigmaticlegacy.util.QuarkHelper;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.client.gui.CuriosScreen;

@EventBusSubscriber(modid="enigmaticlegacy", value={Dist.CLIENT})
public class ScreenEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen || screen instanceof CuriosScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            boolean isCreative = screen instanceof CreativeModeInventoryScreen;
            EnderChestInventoryButton enderButton = new EnderChestInventoryButton(gui, 0, 0, 20, 18, 0, 0, 19, ResourceLocation.fromNamespaceAndPath((String)"enigmaticlegacy", (String)"textures/gui/ender_chest_button.png"), b -> PacketDistributor.sendToServer((CustomPacketPayload)new EnderRingKeyPayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]));
            Tuple<Integer, Integer> enderOffsets = enderButton.getOffsets(isCreative);
            enderButton.setPosition(gui.getGuiLeft() + (Integer)enderOffsets.getA(), gui.getGuiTop() + (Integer)enderOffsets.getB());
            event.addListener((GuiEventListener)enderButton);
            if (QuarkHelper.getMiniButtonClass() != null) {
                event.getListenersList().forEach(listener -> {
                    if (QuarkHelper.getMiniButtonClass().isInstance(listener)) {
                        Button btn = (Button)listener;
                        btn.setY(btn.getY() - 22);
                    }
                });
            }
        }
    }
}

