/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.event;

import net.jrdemiurge.enigmaticlegacy.Config;
import net.jrdemiurge.enigmaticlegacy.EnigmaticLegacy;
import net.jrdemiurge.enigmaticlegacy.entities.custom.PermanentItemEntity;
import net.jrdemiurge.enigmaticlegacy.item.ModItems;
import net.jrdemiurge.enigmaticlegacy.item.custom.SoulCrystal;
import net.jrdemiurge.enigmaticlegacy.item.custom.StorageCrystal;
import net.jrdemiurge.enigmaticlegacy.util.DimensionalPosition;
import net.jrdemiurge.enigmaticlegacy.util.ModUtils;
import net.jrdemiurge.enigmaticlegacy.util.SoulArchive;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

@EventBusSubscriber(modid="enigmaticlegacy")
public class LivingDropsHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            DimensionalPosition dimPoint = new DimensionalPosition(player.getX(), player.getY(), player.getZ(), player.level());
            if (!event.getDrops().isEmpty() && !Config.DISABLE_VESSEL.isTrue()) {
                ItemStack soulCrystal = ModUtils.canDropSoulCrystal((Player)player, ModUtils.isTheCursedOne((Player)player)) ? ((SoulCrystal)ModItems.SOUL_CRYSTAL.get()).createCrystalFrom((Player)player) : null;
                ItemStack storageCrystal = ((StorageCrystal)ModItems.STORAGE_CRYSTAL.get()).storeDropsOnCrystal(event.getDrops(), (Player)player, soulCrystal);
                PermanentItemEntity droppedStorageCrystal = new PermanentItemEntity(dimPoint.world, dimPoint.getPosX(), dimPoint.getPosY() + 1.5, dimPoint.getPosZ(), storageCrystal);
                droppedStorageCrystal.setOwnerId(player.getUUID());
                dimPoint.world.addFreshEntity((Entity)droppedStorageCrystal);
                EnigmaticLegacy.LOGGER.info("Summoned Extradimensional Storage Crystal for " + player.getGameProfile().getName() + " at X: " + dimPoint.getPosX() + ", Y: " + dimPoint.getPosY() + ", Z: " + dimPoint.getPosZ());
                event.getDrops().clear();
                SoulArchive.getInstance().addItem(droppedStorageCrystal);
            } else if (ModUtils.canDropSoulCrystal((Player)player, ModUtils.isTheCursedOne((Player)player))) {
                ItemStack soulCrystal = ((SoulCrystal)ModItems.SOUL_CRYSTAL.get()).createCrystalFrom((Player)player);
                PermanentItemEntity droppedSoulCrystal = new PermanentItemEntity(dimPoint.world, dimPoint.getPosX(), dimPoint.getPosY() + 1.5, dimPoint.getPosZ(), soulCrystal);
                droppedSoulCrystal.setOwnerId(player.getUUID());
                dimPoint.world.addFreshEntity((Entity)droppedSoulCrystal);
                EnigmaticLegacy.LOGGER.info("Teared Soul Crystal from " + player.getGameProfile().getName() + " at X: " + dimPoint.getPosX() + ", Y: " + dimPoint.getPosY() + ", Z: " + dimPoint.getPosZ());
                SoulArchive.getInstance().addItem(droppedSoulCrystal);
            }
        }
    }
}

