/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.event;

import net.jrdemiurge.enigmaticlegacy.Config;
import net.jrdemiurge.enigmaticlegacy.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.enchanting.EnchantmentLevelSetEvent;

@EventBusSubscriber(modid="enigmaticlegacy")
public class EnchantmentLevelSetHandler {
    @SubscribeEvent
    public static void onEnchantmentLevelSet(EnchantmentLevelSetEvent event) {
        BlockPos pos = event.getPos();
        Vec3 c = Vec3.atCenterOf((Vec3i)pos);
        int radius = 16;
        AABB box = new AABB(c, c).inflate((double)radius);
        boolean shouldBoost = false;
        for (Player player : event.getLevel().getEntitiesOfClass(Player.class, box)) {
            if (!ModUtils.isTheCursedOne(player)) continue;
            shouldBoost = true;
        }
        if (shouldBoost) {
            event.setEnchantLevel(event.getEnchantLevel() + (Integer)Config.ENCHANTING_BONUS.get());
        }
    }
}

